/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.StackFrameDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameDescriptorImpl
extends NodeDescriptorImpl
implements StackFrameDescriptor {
    private final StackFrameProxyImpl myFrame;
    private int myUiIndex;
    private String myName = null;
    private Location myLocation;
    private ReferenceType myDeclaringType;
    private MethodsTracker.MethodOccurrence myMethodOccurrence;
    private boolean myIsSynthetic;
    private boolean myIsInLibraryContent;
    private ObjectReference myThisObject;
    private SourcePosition mySourcePosition;
    private Icon myIcon = AllIcons.Debugger.Frame;

    public StackFrameDescriptorImpl(@NotNull StackFrameProxyImpl frame, @NotNull MethodsTracker tracker) {
        this.myFrame = frame;
        try {
            this.myUiIndex = frame.getFrameIndex();
            this.myLocation = frame.location();
            this.myDeclaringType = frame.getDeclaringType();
            try {
                this.myThisObject = frame.thisObject();
            }
            catch (EvaluateException e) {
                if (!(e.getCause() instanceof InternalException)) {
                    throw e;
                }
                LOG.info((Throwable)e);
            }
            this.myMethodOccurrence = tracker.getMethodOccurrence(this.myUiIndex, DebuggerUtilsEx.getMethod(this.myLocation));
            this.myIsSynthetic = DebuggerUtils.isSynthetic((TypeComponent)this.myMethodOccurrence.getMethod());
            this.mySourcePosition = ContextUtil.getSourcePosition(this);
            PsiFile psiFile = this.mySourcePosition != null ? this.mySourcePosition.getFile() : null;
            this.myIsInLibraryContent = DebuggerUtilsEx.isInLibraryContent(psiFile != null ? psiFile.getVirtualFile() : null, this.getDebugProcess().getProject());
        }
        catch (EvaluateException | InternalException e) {
            LOG.info(e);
            this.myLocation = null;
            this.myDeclaringType = null;
            this.myMethodOccurrence = tracker.getMethodOccurrence(0, null);
            this.myIsSynthetic = false;
            this.myIsInLibraryContent = false;
        }
    }

    public int getUiIndex() {
        return this.myUiIndex;
    }

    @NotNull
    public StackFrameProxyImpl getFrameProxy() {
        return this.myFrame;
    }

    @NotNull
    public DebugProcess getDebugProcess() {
        return this.myFrame.getVirtualMachine().getDebugProcess();
    }

    @Nullable
    public Method getMethod() {
        return this.myMethodOccurrence.getMethod();
    }

    public int getOccurrenceIndex() {
        return this.myMethodOccurrence.getIndex();
    }

    public boolean isRecursiveCall() {
        return this.myMethodOccurrence.isRecursive();
    }

    @Nullable
    public ValueMarkup getValueMarkup() {
        XValueMarkers markers;
        XDebugSession session;
        DebugProcess process2;
        if (this.myThisObject != null && (process2 = this.myFrame.getVirtualMachine().getDebugProcess()) instanceof DebugProcessImpl && (session = ((DebugProcessImpl)process2).getSession().getXDebugSession()) instanceof XDebugSessionImpl && (markers = ((XDebugSessionImpl)session).getValueMarkers()) != null) {
            return (ValueMarkup)markers.getAllMarkers().get(this.myThisObject);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myLocation == null) {
            return "";
        }
        ThreadsViewSettings settings = ThreadsViewSettings.getInstance();
        StringBuilder label = new StringBuilder();
        Method method = this.myMethodOccurrence.getMethod();
        if (method != null) {
            this.myName = method.name();
            label.append(settings.SHOW_ARGUMENTS_TYPES ? DebuggerUtilsEx.methodNameWithArguments(method) : this.myName);
        }
        if (settings.SHOW_LINE_NUMBER) {
            label.append(':').append(DebuggerUtilsEx.getLineNumber(this.myLocation, false));
        }
        if (settings.SHOW_CLASS_NAME) {
            String name2;
            try {
                ReferenceType refType = this.myLocation.declaringType();
                name2 = refType != null ? refType.name() : null;
            }
            catch (InternalError e2) {
                name2 = e2.toString();
            }
            if (name2 != null) {
                label.append(", ");
                int dotIndex = name2.lastIndexOf(46);
                if (dotIndex < 0) {
                    label.append(name2);
                } else {
                    label.append(name2.substring(dotIndex + 1));
                    if (settings.SHOW_PACKAGE_NAME) {
                        label.append(" {");
                        label.append(name2, 0, dotIndex);
                        label.append("}");
                    }
                }
            }
        }
        if (settings.SHOW_SOURCE_NAME) {
            label.append(", ").append(DebuggerUtilsEx.getSourceName(this.myLocation, e -> "Unknown Source"));
        }
        return label.toString();
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public final void setContext(EvaluationContextImpl context) {
        this.myIcon = this.calcIcon();
    }

    public boolean isSynthetic() {
        return this.myIsSynthetic;
    }

    public boolean isInLibraryContent() {
        return this.myIsInLibraryContent;
    }

    @Nullable
    public Location getLocation() {
        return this.myLocation;
    }

    @Nullable
    public ReferenceType getDeclaringType() {
        return this.myDeclaringType;
    }

    public SourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    private Icon calcIcon() {
        try {
            if (this.myFrame.isObsolete()) {
                return AllIcons.Debugger.Db_obsolete;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)6));
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public ObjectReference getThisObject() {
        return this.myThisObject;
    }
}

