/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorNameAdjuster;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueDescriptorImpl
extends NodeDescriptorImpl
implements ValueDescriptor {
    protected final Project myProject;
    NodeRenderer myRenderer = null;
    NodeRenderer myAutoRenderer = null;
    private Value myValue;
    private volatile boolean myValueReady;
    private EvaluateException myValueException;
    protected EvaluationContextImpl myStoredEvaluationContext = null;
    private String myIdLabel;
    private String myValueText;
    private boolean myFullValue = false;
    @Nullable
    private Icon myValueIcon;
    protected boolean myIsNew = true;
    private boolean myIsDirty = false;
    private boolean myIsLvalue = false;
    private boolean myIsExpandable;
    private boolean myShowIdLabel = true;

    protected ValueDescriptorImpl(Project project2, Value value) {
        this.myProject = project2;
        this.myValue = value;
        this.myValueReady = true;
    }

    protected ValueDescriptorImpl(Project project2) {
        this.myProject = project2;
    }

    private void assertValueReady() {
        if (!this.myValueReady) {
            LOG.error("Value is not yet calculated for " + this.getClass());
        }
    }

    @Override
    public boolean isArray() {
        this.assertValueReady();
        return this.myValue instanceof ArrayReference;
    }

    public boolean isDirty() {
        this.assertValueReady();
        return this.myIsDirty;
    }

    @Override
    public boolean isLvalue() {
        this.assertValueReady();
        return this.myIsLvalue;
    }

    @Override
    public boolean isNull() {
        this.assertValueReady();
        return this.myValue == null;
    }

    @Override
    public boolean isString() {
        this.assertValueReady();
        return this.myValue instanceof StringReference;
    }

    @Override
    public boolean isPrimitive() {
        this.assertValueReady();
        return this.myValue instanceof PrimitiveValue;
    }

    public boolean isEnumConstant() {
        this.assertValueReady();
        return this.myValue instanceof ObjectReference && ValueDescriptorImpl.isEnumConstant((ObjectReference)this.myValue);
    }

    public boolean isValueValid() {
        return this.myValueException == null;
    }

    public boolean isShowIdLabel() {
        return this.myShowIdLabel && Registry.is((String)"debugger.showTypes");
    }

    public void setShowIdLabel(boolean showIdLabel) {
        this.myShowIdLabel = showIdLabel;
    }

    public boolean isValueReady() {
        return this.myValueReady;
    }

    @Override
    public Value getValue() {
        EvaluationContextImpl evalContext;
        if (Patches.IBM_JDK_DISABLE_COLLECTION_BUG && (evalContext = this.myStoredEvaluationContext) != null && !evalContext.getSuspendContext().isResumed() && this.myValue instanceof ObjectReference && VirtualMachineProxyImpl.isCollected((ObjectReference)this.myValue)) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            evalContext.getDebugProcess().getManagerThread().invoke(new SuspendContextCommandImpl(evalContext.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    try {
                        ValueDescriptorImpl.this.setContext(ValueDescriptorImpl.this.myStoredEvaluationContext);
                    }
                    finally {
                        semaphore.up();
                    }
                }

                @Override
                protected void commandCancelled() {
                    semaphore.up();
                }
            });
            semaphore.waitFor();
        }
        this.assertValueReady();
        return this.myValue;
    }

    @Override
    public boolean isExpandable() {
        return this.myIsExpandable;
    }

    public abstract Value calcValue(EvaluationContextImpl var1) throws EvaluateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setContext(EvaluationContextImpl evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myStoredEvaluationContext = evaluationContext;
        try {
            Value value = this.calcValue(evaluationContext);
            if (!this.myIsNew) {
                try {
                    this.myIsDirty = this.myValue instanceof DoubleValue && Double.isNaN(((DoubleValue)this.myValue).doubleValue()) ? !(value instanceof DoubleValue) : (this.myValue instanceof FloatValue && Float.isNaN(((FloatValue)this.myValue).floatValue()) ? !(value instanceof FloatValue) : !Objects.equals(value, this.myValue));
                }
                catch (ObjectCollectedException ignored) {
                    this.myIsDirty = true;
                }
            }
            this.myValue = value;
            this.myValueException = null;
        }
        catch (EvaluateException e) {
            this.myValueException = e;
            this.setFailed(e);
            this.myValue = ValueDescriptorImpl.getTargetExceptionWithStackTraceFilled(evaluationContext, e, this.isPrintExceptionToConsole() || ApplicationManager.getApplication().isUnitTestMode());
            this.myIsExpandable = false;
        }
        finally {
            this.myValueReady = true;
        }
        this.myIsNew = false;
    }

    protected boolean isPrintExceptionToConsole() {
        return true;
    }

    @Nullable
    protected static Value invokeExceptionGetStackTrace(ObjectReference exceptionObj, EvaluationContextImpl evaluationContext) throws EvaluateException {
        Method method = ((ClassType)exceptionObj.referenceType()).concreteMethodByName("getStackTrace", "()[Ljava/lang/StackTraceElement;");
        if (method != null) {
            return evaluationContext.getDebugProcess().invokeMethod((EvaluationContext)evaluationContext, exceptionObj, method, Collections.emptyList());
        }
        return null;
    }

    @Nullable
    private static ObjectReference getTargetExceptionWithStackTraceFilled(@Nullable EvaluationContextImpl evaluationContext, EvaluateException ex, boolean printToConsole) {
        ObjectReference exceptionObj = ex.getExceptionFromTargetVM();
        if (exceptionObj != null && evaluationContext != null) {
            try {
                Value trace = ValueDescriptorImpl.invokeExceptionGetStackTrace(exceptionObj, evaluationContext);
                if (printToConsole && trace instanceof ArrayReference) {
                    DebugProcessImpl process2 = evaluationContext.getDebugProcess();
                    ArrayReference traceArray = (ArrayReference)trace;
                    process2.printToConsole(DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)exceptionObj) + "\n");
                    for (Value stackElement : traceArray.getValues()) {
                        process2.printToConsole("\tat " + DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)stackElement) + "\n");
                    }
                }
            }
            catch (EvaluateException trace) {
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return exceptionObj;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        this.myIsNew = false;
        if (!this.myValueReady) {
            ValueDescriptorImpl other = (ValueDescriptorImpl)oldDescriptor;
            if (other.myValueReady) {
                this.myValue = other.getValue();
                this.myValueReady = true;
            }
        }
    }

    protected void setLvalue(boolean value) {
        this.myIsLvalue = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        String label;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess = context.getDebugProcess();
        NodeRenderer renderer = this.getRenderer(debugProcess);
        EvaluateException valueException = this.myValueException;
        this.myIsExpandable = (valueException == null || valueException.getExceptionFromTargetVM() != null) && this.getChildrenRenderer(debugProcess).isExpandable(this.getValue(), context, this);
        try {
            this.setValueIcon(renderer.calcValueIcon(this, context, labelListener));
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            this.setValueIcon(null);
        }
        if (valueException == null) {
            long start = renderer instanceof NodeRendererImpl && ((NodeRendererImpl)renderer).hasOverhead() ? System.currentTimeMillis() : 0L;
            try {
                label = renderer.calcLabel(this, context, labelListener);
            }
            catch (EvaluateException e) {
                label = this.setValueLabelFailed(e);
            }
            finally {
                if (start > 0L) {
                    OverheadTimings.add(debugProcess, new NodeRendererImpl.Overhead((NodeRendererImpl)renderer), 1L, System.currentTimeMillis() - start);
                }
            }
        } else {
            label = this.setValueLabelFailed(valueException);
        }
        this.setValueLabel(label);
        return "";
    }

    @Override
    public String getLabel() {
        return this.calcValueName() + this.getDeclaredTypeLabel() + " = " + this.getValueLabel();
    }

    public ValueDescriptorImpl getFullValueDescriptor() {
        ValueDescriptorImpl descriptor2 = new ValueDescriptorImpl(this.myProject, this.myValue){

            @Override
            public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
                return ValueDescriptorImpl.this.myValue;
            }

            @Override
            public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
                return null;
            }

            @Override
            public NodeRenderer getRenderer(DebugProcessImpl debugProcess) {
                return ValueDescriptorImpl.this.getRenderer(debugProcess);
            }

            @Override
            public <T> T getUserData(Key<T> key) {
                return ValueDescriptorImpl.this.getUserData(key);
            }
        };
        descriptor2.myFullValue = true;
        return descriptor2;
    }

    @Override
    public void setValueLabel(@NotNull String label) {
        label = this.myFullValue ? label : DebuggerUtilsEx.truncateString(label);
        Value value = this.myValueReady ? this.getValue() : null;
        NodeRendererImpl lastRenderer = (NodeRendererImpl)this.getLastRenderer();
        EvaluationContextImpl evalContext = this.myStoredEvaluationContext;
        String labelId = this.myValueReady && evalContext != null && lastRenderer != null && !evalContext.getSuspendContext().isResumed() ? lastRenderer.getIdLabel(value, evalContext.getDebugProcess()) : null;
        this.myValueText = label;
        this.myIdLabel = this.isShowIdLabel() ? labelId : null;
    }

    @Override
    public String setValueLabelFailed(EvaluateException e) {
        String label = this.setFailed(e);
        this.setValueLabel(label);
        return label;
    }

    @Override
    public Icon setValueIcon(Icon icon) {
        this.myValueIcon = icon;
        return this.myValueIcon;
    }

    @Nullable
    public Icon getValueIcon() {
        return this.myValueIcon;
    }

    public String calcValueName() {
        String name2 = this.getName();
        NodeDescriptorNameAdjuster nameAdjuster = NodeDescriptorNameAdjuster.findFor((NodeDescriptor)this);
        if (nameAdjuster != null) {
            return nameAdjuster.fixName(name2, (NodeDescriptor)this);
        }
        return name2;
    }

    @Nullable
    public String getDeclaredType() {
        return null;
    }

    @Override
    public void displayAs(NodeDescriptor descriptor2) {
        if (descriptor2 instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor2;
            this.myRenderer = valueDescriptor.myRenderer;
        }
        super.displayAs(descriptor2);
    }

    public Renderer getLastRenderer() {
        return this.myRenderer != null ? this.myRenderer : this.myAutoRenderer;
    }

    public Renderer getLastLabelRenderer() {
        Renderer lastRenderer = this.getLastRenderer();
        if (lastRenderer instanceof CompoundTypeRenderer) {
            lastRenderer = ((CompoundTypeRenderer)lastRenderer).getLabelRenderer();
        }
        return lastRenderer;
    }

    public NodeRenderer getChildrenRenderer(DebugProcessImpl debugProcess) {
        return OnDemandRenderer.isOnDemandForced(debugProcess) ? DebugProcessImpl.getDefaultRenderer(this.getValue()) : this.getRenderer(debugProcess);
    }

    public NodeRenderer getRenderer(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Type type = this.getType();
        if (type != null && this.myRenderer != null && this.myRenderer.isApplicable(type)) {
            return this.myRenderer;
        }
        this.myAutoRenderer = debugProcess.getAutoRenderer(this);
        return this.myAutoRenderer;
    }

    public void setRenderer(NodeRenderer renderer) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myRenderer = renderer;
        this.myAutoRenderer = null;
    }

    @Nullable
    public PsiElement getTreeEvaluation(JavaValue value, DebuggerContextImpl context) throws EvaluateException {
        JavaValue parent = value.getParent();
        if (parent != null) {
            ValueDescriptorImpl vDescriptor = parent.getDescriptor();
            PsiElement parentEvaluation = vDescriptor.getTreeEvaluation(parent, context);
            if (!(parentEvaluation instanceof PsiExpression)) {
                return null;
            }
            return DebuggerTreeNodeExpression.substituteThis(vDescriptor.getChildrenRenderer(context.getDebugProcess()).getChildValueExpression(new DebuggerTreeNodeMock(value), context), (PsiExpression)parentEvaluation, vDescriptor.getValue());
        }
        return this.getDescriptorEvaluation(context);
    }

    public abstract PsiExpression getDescriptorEvaluation(DebuggerContext var1) throws EvaluateException;

    public static String getIdLabel(ObjectReference objRef) {
        int idx;
        boolean showConcreteType;
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        if (objRef instanceof StringReference && !classRenderer.SHOW_STRINGS_TYPE) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean bl = showConcreteType = !classRenderer.SHOW_DECLARED_TYPE || !(objRef instanceof StringReference) && !(objRef instanceof ClassObjectReference) && !ValueDescriptorImpl.isEnumConstant(objRef);
        if (showConcreteType || classRenderer.SHOW_OBJECT_ID) {
            if (showConcreteType) {
                buf.append(classRenderer.renderTypeName(objRef.type().name()));
            }
            if (classRenderer.SHOW_OBJECT_ID) {
                buf.append('@');
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    buf.append("uniqueID");
                } else {
                    buf.append(objRef.uniqueID());
                }
            }
        }
        if (objRef instanceof ArrayReference && (idx = buf.indexOf("[")) >= 0) {
            buf.insert(idx + 1, ((ArrayReference)objRef).length());
        }
        return buf.toString();
    }

    private static boolean isEnumConstant(ObjectReference objRef) {
        try {
            Type type = objRef.type();
            return type instanceof ClassType && ((ClassType)type).isEnum();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return false;
        }
    }

    public boolean canSetValue() {
        return this.myValueReady && !this.myIsSynthetic && this.isLvalue();
    }

    public XValueModifier getModifier(JavaValue value) {
        return null;
    }

    public String getIdLabel() {
        return this.myIdLabel;
    }

    public String getValueLabel() {
        String label = this.getIdLabel();
        if (!StringUtil.isEmpty((String)label)) {
            return '{' + label + '}' + this.getValueText();
        }
        return this.getValueText();
    }

    @NotNull
    public String getValueText() {
        return StringUtil.notNullize((String)this.myValueText);
    }

    @Override
    public void clear() {
        super.clear();
        this.setValueLabel("");
        this.myIsExpandable = false;
    }

    @Override
    @Nullable
    public ValueMarkup getMarkup(DebugProcess debugProcess) {
        Value value = this.getValue();
        if (value instanceof ObjectReference) {
            ObjectReference objRef = (ObjectReference)value;
            Map<ObjectReference, ValueMarkup> map2 = ValueDescriptorImpl.getMarkupMap(debugProcess);
            if (map2 != null) {
                return map2.get(objRef);
            }
        }
        return null;
    }

    @Override
    public void setMarkup(DebugProcess debugProcess, @Nullable ValueMarkup markup) {
        Map<ObjectReference, ValueMarkup> map2;
        Value value = this.getValue();
        if (value instanceof ObjectReference && (map2 = ValueDescriptorImpl.getMarkupMap(debugProcess)) != null) {
            ObjectReference objRef = (ObjectReference)value;
            if (markup != null) {
                map2.put(objRef, markup);
            } else {
                map2.remove(objRef);
            }
        }
    }

    public boolean canMark() {
        if (!this.myValueReady) {
            return false;
        }
        return this.getValue() instanceof ObjectReference;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getDeclaredTypeLabel() {
        String declaredType;
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        if (classRenderer.SHOW_DECLARED_TYPE && !StringUtil.isEmpty((String)(declaredType = this.getDeclaredType()))) {
            return ": " + classRenderer.renderTypeName(declaredType);
        }
        return "";
    }

    public EvaluationContextImpl getStoredEvaluationContext() {
        return this.myStoredEvaluationContext;
    }

    private static class DebuggerTreeNodeMock
    implements DebuggerTreeNode {
        private final JavaValue value;

        DebuggerTreeNodeMock(JavaValue value) {
            this.value = value;
        }

        @Override
        public DebuggerTreeNode getParent() {
            return new DebuggerTreeNodeMock(this.value.getParent());
        }

        @Override
        public ValueDescriptorImpl getDescriptor() {
            return this.value.getDescriptor();
        }

        @Override
        public Project getProject() {
            return this.value.getProject();
        }

        @Override
        public void setRenderer(NodeRenderer renderer) {
        }
    }
}

