/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.actions;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.LongType;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ShortType;
import com.sun.jdi.Type;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;

public class ShowAllAs
extends AnAction {
    private final NodeRenderer myRenderer;

    public ShowAllAs(NodeRenderer renderer) {
        this.myRenderer = renderer;
    }

    private static boolean isPrimitiveArray(DebuggerTreeNode selectedNode) {
        try {
            ArrayReference arrayReference;
            Type componentType;
            ValueDescriptor valueDescriptor;
            if (selectedNode.getDescriptor() instanceof ValueDescriptor && (valueDescriptor = (ValueDescriptor)selectedNode.getDescriptor()).isArray() && (componentType = ((ArrayType)(arrayReference = (ArrayReference)valueDescriptor.getValue()).type()).componentType()) instanceof PrimitiveType && (componentType instanceof ByteType || componentType instanceof ShortType || componentType instanceof IntegerType || componentType instanceof LongType)) {
                return true;
            }
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        DebuggerTreeNode selectedNode = ((DebuggerUtilsEx)DebuggerUtils.getInstance()).getSelectedNode(e.getDataContext());
        e.getPresentation().setVisible(this.myRenderer != null && selectedNode != null && ShowAllAs.isPrimitiveArray(selectedNode));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DebuggerTreeNodeImpl selectedNode = (DebuggerTreeNodeImpl)((DebuggerUtilsEx)DebuggerUtils.getInstance()).getSelectedNode(e.getDataContext());
        if (selectedNode == null) {
            return;
        }
        if (!ShowAllAs.isPrimitiveArray(selectedNode)) {
            return;
        }
        final DebuggerContext debuggerContext = DebuggerUtils.getInstance().getDebuggerContext(e.getDataContext());
        if (debuggerContext == null || debuggerContext.getDebugProcess() == null) {
            return;
        }
        Enumeration children = selectedNode.children();
        while (children.hasMoreElements()) {
            final DebuggerTreeNode child = (DebuggerTreeNode)children.nextElement();
            if (!(child.getDescriptor() instanceof ValueDescriptor)) continue;
            debuggerContext.getDebugProcess().getManagerThread().invokeCommand((DebuggerCommand)new SuspendContextCommand(){

                public SuspendContext getSuspendContext() {
                    return debuggerContext.getSuspendContext();
                }

                public void action() {
                    child.setRenderer(ShowAllAs.this.myRenderer);
                }

                public void commandCancelled() {
                }
            });
        }
    }
}

