/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CustomPopupFullValueEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.ImageSerializer;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImageObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    private static final Logger LOG = Logger.getInstance(ImageObjectRenderer.class);

    ImageObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Image", null, null);
        this.setClassName("java.awt.Image");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        return new IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContext){

            @Override
            protected Icon getData() {
                return ImageObjectRenderer.getIcon(this.getEvaluationContext(), valueDescriptor.getValue(), "imageToBytes");
            }
        };
    }

    static JComponent createIconViewer(@Nullable Icon icon) {
        if (icon == null) {
            return new JLabel("No data", 0);
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
    }

    @Nullable
    static ImageIcon getIcon(EvaluationContext evaluationContext, Value obj, String methodName) {
        try {
            Value bytes = ImageObjectRenderer.getImageBytes(evaluationContext, obj, methodName);
            byte[] data = DebuggerUtilsImpl.readBytesArray(bytes);
            if (data != null) {
                return new ImageIcon(data);
            }
        }
        catch (Exception e) {
            LOG.info("Exception while getting image data", (Throwable)e);
        }
        return null;
    }

    private static Value getImageBytes(EvaluationContext evaluationContext, Value obj, String methodName) throws EvaluateException {
        List<Method> methods;
        DebugProcess process2 = evaluationContext.getDebugProcess();
        EvaluationContext copyContext = evaluationContext.createEvaluationContext(obj);
        ClassType helperClass = ClassLoadingUtils.getHelperClass(ImageSerializer.class, copyContext);
        if (helperClass != null && !(methods = helperClass.methodsByName(methodName)).isEmpty()) {
            return process2.invokeMethod(copyContext, helperClass, methods.get(0), Collections.singletonList(obj));
        }
        return null;
    }

    static abstract class IconPopupEvaluator
    extends CustomPopupFullValueEvaluator<Icon> {
        IconPopupEvaluator(@NotNull String linkText, @NotNull EvaluationContextImpl evaluationContext) {
            super(linkText, evaluationContext);
        }

        @Override
        protected JComponent createComponent(Icon data) {
            return ImageObjectRenderer.createIconViewer(data);
        }
    }
}

