/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.actions.ForceOnDemandRenderersAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OnDemandRenderer
extends FullValueEvaluatorProvider {
    public static final Key<Boolean> ON_DEMAND_CALCULATED = Key.create((String)"ON_DEMAND_CALCULATED");

    @Override
    @Nullable
    default public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, ValueDescriptorImpl valueDescriptor) {
        if (this.isOnDemand(evaluationContext, valueDescriptor) && !OnDemandRenderer.isCalculated(valueDescriptor)) {
            return OnDemandRenderer.createFullValueEvaluator(this.getLinkText());
        }
        return null;
    }

    public String getLinkText();

    default public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        return OnDemandRenderer.isOnDemandForced((DebugProcessImpl)evaluationContext.getDebugProcess());
    }

    default public boolean isShowValue(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext) {
        return !this.isOnDemand(evaluationContext, valueDescriptor) || OnDemandRenderer.isCalculated(valueDescriptor);
    }

    public static XFullValueEvaluator createFullValueEvaluator(String text) {
        return new XFullValueEvaluator(text){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback instanceof HeadlessValueEvaluationCallback) {
                    XValueNodeImpl node = ((HeadlessValueEvaluationCallback)callback).getNode();
                    node.clearFullValueEvaluator();
                    OnDemandRenderer.setCalculated(((JavaValue)node.getValueContainer()).getDescriptor());
                    ((XValue)node.getValueContainer()).computePresentation((XValueNode)node, XValuePlace.TREE);
                }
                callback.evaluated("");
            }
        }.setShowValuePopup(false);
    }

    public static boolean isCalculated(ValueDescriptor descriptor2) {
        return (Boolean)ON_DEMAND_CALCULATED.get((UserDataHolder)descriptor2, (Object)false);
    }

    public static void setCalculated(ValueDescriptor descriptor2) {
        ON_DEMAND_CALCULATED.set((UserDataHolder)descriptor2, (Object)true);
    }

    public static boolean isOnDemandForced(DebugProcessImpl debugProcess) {
        JavaDebugProcess process2 = debugProcess.getXdebugProcess();
        return process2 != null && ForceOnDemandRenderersAction.isForcedOnDemand((XDebugSessionImpl)process2.getSession());
    }
}

