/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.DesignerCustomizations;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.DesignerToolWindow;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DesignerToolWindowManager
extends AbstractToolWindowManager {
    private DesignerToolWindow myToolWindowContent;

    public DesignerToolWindowManager(Project project2, FileEditorManager fileEditorManager) {
        super(project2, fileEditorManager);
    }

    public static DesignerToolWindow getInstance(DesignerEditorPanel designer) {
        DesignerToolWindowManager manager = DesignerToolWindowManager.getInstance(designer.getProject());
        if (manager.isEditorMode()) {
            return (DesignerToolWindow)manager.getContent(designer);
        }
        return manager.myToolWindowContent;
    }

    public static DesignerToolWindowManager getInstance(Project project2) {
        return (DesignerToolWindowManager)((Object)project2.getComponent(DesignerToolWindowManager.class));
    }

    protected void initToolWindow() {
        if (this.myToolWindowContent == null) {
            this.myToolWindowContent = new DesignerToolWindow(this.myProject, true);
            Disposer.register((Disposable)this, () -> this.myToolWindowContent.dispose());
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(DesignerBundle.message("designer.toolwindow.name", new Object[0]), false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowUIDesigner);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        }
        ((ToolWindowEx)this.myToolWindow).setTitleActions(this.myToolWindowContent.createActions());
        this.initGearActions();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)this.myToolWindowContent.getToolWindowPanel(), DesignerBundle.message("designer.toolwindow.title", new Object[0]), false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)((Object)this.myToolWindowContent.getComponentTree()));
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false, null);
    }

    protected ToolWindowAnchor getAnchor() {
        DesignerCustomizations customization = DesignerToolWindowManager.getCustomizations();
        return customization != null ? customization.getStructureAnchor() : ToolWindowAnchor.LEFT;
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myToolWindowContent.update((DesignerEditorPanel)designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    @NotNull
    public String getComponentName() {
        return "UIDesignerToolWindowManager2";
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        DesignerToolWindow toolWindowContent = new DesignerToolWindow(this.myProject, false);
        toolWindowContent.update((DesignerEditorPanel)designer);
        return this.createContent(designer, toolWindowContent, DesignerBundle.message("designer.toolwindow.title", new Object[0]), AllIcons.Toolwindows.ToolWindowUIDesigner, (JComponent)toolWindowContent.getToolWindowPanel(), (JComponent)((Object)toolWindowContent.getComponentTree()), 320, toolWindowContent.createActions());
    }
}

