/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.model.WrapInProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ThrowableRunnable;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WrapInAction
extends AnAction {
    private final DesignerEditorPanel myDesigner;
    private final EditableArea myArea;
    private final WrapInProvider myProvider;
    private final RadComponent myParent;
    private final List<RadComponent> myComponents;
    private final MetaModel myTarget;

    public WrapInAction(DesignerEditorPanel designer, EditableArea area, WrapInProvider provider2, RadComponent parent, List<RadComponent> components, MetaModel target) {
        super(target.getTag(), null, target.getIcon());
        this.myDesigner = designer;
        this.myArea = area;
        this.myProvider = provider2;
        this.myParent = parent;
        this.myComponents = components;
        this.myTarget = target;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myDesigner.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> this.myArea.select(this.myProvider.wrapIn(this.myParent, this.myComponents, this.myTarget))), "Run Wrap In action", true);
    }

    public static void fill(DesignerEditorPanel designer, DefaultActionGroup group, EditableArea area) {
        RadLayout layout;
        List<RadComponent> selection = area.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Set<RadComponent> parents = RadComponent.getParents(selection);
        if (parents.size() != 1) {
            return;
        }
        RadComponent parent = parents.iterator().next();
        if (selection.size() > 1 && (layout = parent.getLayout()) != null && !layout.isWrapIn(selection)) {
            return;
        }
        WrapInProvider provider2 = designer.getWrapInProvider();
        if (provider2 == null) {
            return;
        }
        List<MetaModel> models = provider2.getModels();
        if (models.isEmpty()) {
            return;
        }
        DefaultActionGroup wrapGroup = new DefaultActionGroup("Wrap In", true);
        for (MetaModel wrapModel : models) {
            wrapGroup.add((AnAction)new WrapInAction(designer, area, provider2, parent, selection, wrapModel));
        }
    }
}

