/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.componentTree.TreeNodeDescriptor;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.model.RadComponent;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import org.jetbrains.annotations.NotNull;

public final class TreeContentProvider
extends AbstractTreeStructure {
    private final DesignerEditorPanel myDesigner;
    private final Object myTreeRoot = new Object();

    public TreeContentProvider(DesignerEditorPanel designer) {
        this.myDesigner = designer;
    }

    @NotNull
    public Object getRootElement() {
        return this.myTreeRoot;
    }

    @NotNull
    public Object[] getChildElements(@NotNull Object element) {
        if (element == this.myTreeRoot) {
            return this.myDesigner.getTreeRoots();
        }
        if (element instanceof RadComponent) {
            RadComponent component = (RadComponent)((Object)element);
            return component.getTreeChildren();
        }
        throw new IllegalArgumentException("Unknown element: " + element);
    }

    public Object getParentElement(@NotNull Object element) {
        if (element instanceof RadComponent) {
            RadComponent component = (RadComponent)((Object)element);
            return component.getParent();
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == this.myTreeRoot || element instanceof RadComponent) {
            TreeNodeDescriptor descriptor2 = new TreeNodeDescriptor(parentDescriptor, element);
            descriptor2.setWasDeclaredAlwaysLeaf(this.isAlwaysLeaf(element));
            return descriptor2;
        }
        throw new IllegalArgumentException("Unknown element: " + element);
    }

    public boolean isAlwaysLeaf(@NotNull Object element) {
        return element instanceof RadComponent && ((RadComponent)((Object)element)).getTreeChildren().length == 0;
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    public void commit() {
    }
}

