/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.QuickFix;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.impl.VisibilityWatcher;
import com.intellij.ui.ClickListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.RowIcon;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQuickFixManager {
    protected DesignerEditorPanel myDesigner;
    protected final JComponent myComponent;
    private final JViewport myViewPort;
    private final Alarm myAlarm = new Alarm();
    private final Runnable myShowHintRequest;
    private LightweightHint myHint;
    private Rectangle myLastHintBounds;
    private static final Border INACTIVE_BORDER = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private static final Border ACTIVE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.orange, 2), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    private static final Icon INACTIVE_ARROW_ICON = EmptyIcon.create((Icon)AllIcons.General.ArrowDown);

    public AbstractQuickFixManager(@Nullable DesignerEditorPanel designer, JComponent component, JViewport viewPort) {
        this.myDesigner = designer;
        this.myComponent = component;
        this.myViewPort = viewPort;
        this.myShowHintRequest = () -> this.showHint();
        new VisibilityWatcher(){

            public void visibilityChanged() {
                if (AbstractQuickFixManager.this.myComponent.isShowing()) {
                    AbstractQuickFixManager.this.updateHintVisibility();
                } else {
                    AbstractQuickFixManager.this.hideHint();
                }
            }
        }.install((Component)component);
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    AbstractQuickFixManager.this.updateHintVisibility();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    AbstractQuickFixManager.this.hideHint();
                }
            }
        });
        AnAction showHintAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (AbstractQuickFixManager.this.myDesigner != null) {
                    AbstractQuickFixManager.this.showHint();
                    AbstractQuickFixManager.this.showPopup();
                }
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(e.getData(CommonDataKeys.EDITOR) == null);
            }
        };
        showHintAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ShowIntentionActions").getShortcutSet(), component);
        viewPort.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractQuickFixManager.this.updateHintPosition();
            }
        });
    }

    public void setDesigner(@Nullable DesignerEditorPanel designer) {
        this.myDesigner = designer;
    }

    public void update() {
        if (!this.myComponent.isShowing() || !IJSwingUtilities.hasFocus((Component)this.myComponent)) {
            this.hideHint();
        } else if (this.myHint == null || !this.myHint.isVisible()) {
            this.updateHintVisibility();
        } else {
            Rectangle bounds = this.getErrorBounds();
            if (!ErrorInfo.haveFixes(this.getErrorInfos()) || bounds == null || !bounds.equals(this.myLastHintBounds)) {
                this.hideHint();
                this.updateHintVisibility();
            }
        }
    }

    private void showHint() {
        Rectangle bounds;
        if (!this.myComponent.isShowing() || !IJSwingUtilities.hasFocus((Component)this.myComponent)) {
            this.hideHint();
            return;
        }
        this.hideHint();
        List<ErrorInfo> infos = this.getErrorInfos();
        if (!ErrorInfo.haveFixes(infos)) {
            this.hideHint();
            return;
        }
        boolean error = false;
        for (ErrorInfo errorInfo : infos) {
            if (errorInfo.getLevel() != HighlightDisplayLevel.ERROR) continue;
            error = true;
            break;
        }
        if ((bounds = this.getErrorBounds()) == null) {
            return;
        }
        this.myHint = new LightweightHint((JComponent)new InspectionHint(error ? AllIcons.Actions.QuickfixBulb : AllIcons.Actions.IntentionBulb));
        this.myLastHintBounds = bounds;
        this.myHint.show(this.myComponent, bounds.x - AllIcons.Actions.IntentionBulb.getIconWidth() - 4, bounds.y, this.myComponent, new HintHint((Component)this.myComponent, bounds.getLocation()));
    }

    private void showPopup() {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        List<ErrorInfo> errorInfos = this.getErrorInfos();
        if (!ErrorInfo.haveFixes(errorInfos)) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new FirstStep(errorInfos));
        popup.showUnderneathOf((Component)this.myHint.getComponent());
    }

    public final void hideHint() {
        this.myAlarm.cancelAllRequests();
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.hide();
            this.myHint = null;
            this.myComponent.paintImmediately(this.myComponent.getVisibleRect());
        }
    }

    protected final void updateHintVisibility() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this.myShowHintRequest, 500);
    }

    private void updateHintPosition() {
        Rectangle rc;
        if (this.myHint != null && this.myHint.isVisible() && (rc = this.getErrorBounds()) != null) {
            this.myLastHintBounds = rc;
            Rectangle hintRect = new Rectangle(rc.x - AllIcons.Actions.IntentionBulb.getIconWidth() - 4, rc.y, AllIcons.Actions.IntentionBulb.getIconWidth() + 4, AllIcons.Actions.IntentionBulb.getIconHeight() + 4);
            if (this.getHintClipRect().contains(hintRect)) {
                this.myHint.updateLocation(hintRect.x, hintRect.y);
            } else {
                this.myHint.hide();
            }
        }
    }

    protected Rectangle getHintClipRect() {
        return this.myViewPort.getViewRect();
    }

    @NotNull
    protected abstract List<ErrorInfo> getErrorInfos();

    @Nullable
    protected abstract Rectangle getErrorBounds();

    private Runnable getQuickFixRunnable(QuickFix value) {
        return () -> this.myDesigner.getToolProvider().executeWithReparse((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ApplicationManager.getApplication().runWriteAction((Runnable)value)), "Run '" + value.getName() + "' QuickFix");
    }

    private class InspectionHint
    extends JLabel {
        private final RowIcon myInactiveIcon;
        private final RowIcon myActiveIcon;

        private InspectionHint(Icon icon) {
            this.setOpaque(false);
            this.setBorder(INACTIVE_BORDER);
            this.myActiveIcon = new RowIcon(2);
            this.myActiveIcon.setIcon(icon, 0);
            this.myActiveIcon.setIcon(AllIcons.General.ArrowDown, 1);
            this.myInactiveIcon = new RowIcon(2);
            this.myInactiveIcon.setIcon(icon, 0);
            this.myInactiveIcon.setIcon(INACTIVE_ARROW_ICON, 1);
            this.setIcon((Icon)this.myInactiveIcon);
            String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
            if (acceleratorsText.length() > 0) {
                this.setToolTipText(DesignerBundle.message("tooltip.press.accelerator", acceleratorsText));
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    InspectionHint.this.setIcon((Icon)InspectionHint.this.myActiveIcon);
                    InspectionHint.this.setBorder(ACTIVE_BORDER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    InspectionHint.this.setIcon((Icon)InspectionHint.this.myInactiveIcon);
                    InspectionHint.this.setBorder(INACTIVE_BORDER);
                }
            });
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                    AbstractQuickFixManager.this.showPopup();
                    return true;
                }
            }.installOn((Component)this);
        }
    }

    private class SecondStep
    extends BaseListPopupStep<QuickFix> {
        SecondStep(List<? extends QuickFix> fixList) {
            super(null, fixList);
        }

        public Icon getIconFor(QuickFix value) {
            return value.getIcon();
        }

        @NotNull
        public String getTextFor(QuickFix value) {
            return value.getName();
        }

        public PopupStep onChosen(QuickFix value, boolean finalChoice) {
            return this.doFinalStep(AbstractQuickFixManager.this.getQuickFixRunnable(value));
        }
    }

    private class FirstStep
    extends BaseListPopupStep<ErrorInfo> {
        FirstStep(List<ErrorInfo> errorInfos) {
            super(null, errorInfos);
        }

        public Icon getIconFor(ErrorInfo value) {
            return AllIcons.Actions.RealIntentionBulb;
        }

        @NotNull
        public String getTextFor(ErrorInfo value) {
            return value.getName();
        }

        public PopupStep onChosen(ErrorInfo value, boolean finalChoice) {
            List quickFixes = value.getQuickFixes();
            if (finalChoice) {
                return this.doFinalStep(AbstractQuickFixManager.this.getQuickFixRunnable((QuickFix)quickFixes.get(0)));
            }
            return new SecondStep(quickFixes);
        }

        public boolean hasSubstep(ErrorInfo selectedValue) {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }
    }
}

