/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.propertyTable.PropertyTableTab;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.designer.propertyTable.TablePanelActionPolicy;
import com.intellij.designer.propertyTable.actions.IPropertyTableAction;
import com.intellij.designer.propertyTable.actions.RestoreDefault;
import com.intellij.designer.propertyTable.actions.ShowColumns;
import com.intellij.designer.propertyTable.actions.ShowExpert;
import com.intellij.designer.propertyTable.actions.ShowJavadoc;
import com.intellij.designer.propertyTable.actions.TableTabAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyTablePanel
extends JPanel
implements ListSelectionListener {
    private static final String BUTTON_KEY = "SWING_BUTTON_KEY";
    private final RadPropertyTable myPropertyTable;
    private final AnAction[] myActions;
    private final JPanel myTabPanel;
    private final JPanel myActionPanel;
    private PropertyTableTab[] myTabs;
    private PropertyTableTab myCurrentTab;
    private TablePanelActionPolicy myActionPolicy;
    private final JLabel myTitleLabel;

    public PropertyTablePanel(final Project project2) {
        this.myPropertyTable = new RadPropertyTable(project2){

            protected void updateEditActions() {
                PropertyTablePanel.this.updateActions();
            }
        };
        this.setLayout(new GridBagLayout());
        int gridX = 0;
        this.myTitleLabel = new JLabel(DesignerBundle.message("designer.properties.title", new Object[0]));
        this.myTitleLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.add((Component)this.myTitleLabel, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 5, 2, 10), 0, 0));
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ShowJavadoc showJavadoc = new ShowJavadoc(this.myPropertyTable);
        showJavadoc.registerCustomShortcutSet(actionManager.getAction("QuickJavaDoc").getShortcutSet(), (JComponent)((Object)this.myPropertyTable));
        actionGroup.add((AnAction)showJavadoc);
        actionGroup.addSeparator();
        RestoreDefault restoreDefault = new RestoreDefault(this.myPropertyTable);
        restoreDefault.registerCustomShortcutSet(actionManager.getAction("$Delete").getShortcutSet(), (JComponent)((Object)this.myPropertyTable));
        actionGroup.add((AnAction)restoreDefault);
        actionGroup.add((AnAction)new ShowExpert(this.myPropertyTable));
        this.myTabPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.add((Component)this.myTabPanel, new GridBagConstraints(gridX++, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.myActionPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.add((Component)this.myActionPanel, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        for (AnAction action : this.myActions = actionGroup.getChildren(null)) {
            if (action instanceof Separator) continue;
            Presentation presentation = action.getTemplatePresentation();
            ActionButton button = new ActionButton(action, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.myActionPanel.add((Component)button);
            presentation.putClientProperty(BUTTON_KEY, (Object)button);
        }
        actionGroup.add((AnAction)new ShowColumns(this.myPropertyTable));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myPropertyTable), (ActionGroup)actionGroup, (String)"GuiDesigner.PropertyInspectorPopup", (ActionManager)actionManager);
        this.myPropertyTable.getSelectionModel().addListSelectionListener(this);
        this.valueChanged(null);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myPropertyTable));
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)2));
        this.myPropertyTable.initQuickFixManager(scrollPane.getViewport());
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, gridX, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myPropertyTable.setPropertyTablePanel(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                IdeFocusManager.getInstance((Project)project2).requestFocus((Component)((Object)PropertyTablePanel.this.myPropertyTable), true);
            }
        });
    }

    public void setArea(@Nullable DesignerEditorPanel designer, @Nullable EditableArea area) {
        TablePanelActionPolicy policy;
        Object[] tabs;
        Object[] objectArray = tabs = designer == null ? null : designer.getPropertyTableTabs();
        if (!Comparing.equal((Object[])this.myTabs, (Object[])tabs)) {
            this.myTabs = tabs;
            this.myTabPanel.removeAll();
            if (tabs != null && tabs.length > 1) {
                if (!ArrayUtil.contains((Object)this.myCurrentTab, (Object[])tabs)) {
                    this.myCurrentTab = tabs[0];
                }
                for (Object tab : tabs) {
                    this.myTabPanel.add((Component)new TableTabAction(this, (PropertyTableTab)tab).getButton());
                }
            } else {
                this.myCurrentTab = null;
            }
            this.myTitleLabel.setVisible(this.myCurrentTab == null);
            this.myTabPanel.revalidate();
        }
        TablePanelActionPolicy tablePanelActionPolicy = policy = designer == null ? TablePanelActionPolicy.EMPTY : designer.getTablePanelActionPolicy();
        if (!Comparing.equal((Object)this.myActionPolicy, (Object)policy)) {
            this.myActionPolicy = policy;
            for (AnAction action : this.myActions) {
                if (action instanceof Separator) continue;
                boolean visible = policy.showAction(action);
                Presentation presentation = action.getTemplatePresentation();
                presentation.setVisible(visible);
                JComponent button = (JComponent)presentation.getClientProperty(BUTTON_KEY);
                if (button == null) continue;
                button.setVisible(visible);
            }
            this.myActionPanel.revalidate();
        }
        this.myPropertyTable.setArea(designer, area);
    }

    public RadPropertyTable getPropertyTable() {
        return this.myPropertyTable;
    }

    @Nullable
    public PropertyTableTab getCurrentTab() {
        return this.myCurrentTab;
    }

    public void setCurrentTab(@NotNull PropertyTableTab currentTab) {
        this.myCurrentTab = currentTab;
        for (Component component : this.myTabPanel.getComponents()) {
            ActionButton button = (ActionButton)component;
            TableTabAction action = (TableTabAction)button.getAction();
            action.updateState();
        }
        this.myPropertyTable.update();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateActions();
    }

    public void updateActions() {
        for (AnAction action : this.myActions) {
            if (!(action instanceof IPropertyTableAction)) continue;
            ((IPropertyTableAction)action).update();
        }
    }
}

