/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.lang.Language;
import gnu.trove.TIntObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesProfileCache {
    private static final Map<DupInfo, TIntObjectHashMap<DuplicatesProfile>> ourProfileCache = new HashMap<DupInfo, TIntObjectHashMap<DuplicatesProfile>>();
    private static final DuplicatesProfile NULL_PROFILE = new DuplicatesProfile(){

        @Override
        @NotNull
        public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector) {
            return null;
        }

        @Override
        public boolean isMyLanguage(@NotNull Language language) {
            return false;
        }

        @Override
        @NotNull
        public DuplocatorState getDuplocatorState(@NotNull Language language) {
            return null;
        }

        @Override
        public boolean isMyDuplicate(@NotNull DupInfo info, int index) {
            return false;
        }
    };

    private DuplicatesProfileCache() {
    }

    public static void clear(@NotNull DupInfo info) {
        ourProfileCache.remove(info);
    }

    @Nullable
    public static DuplicatesProfile getProfile(@NotNull DupInfo dupInfo, int index) {
        DuplicatesProfile result;
        TIntObjectHashMap patternCache = ourProfileCache.get(dupInfo);
        if (patternCache == null) {
            patternCache = new TIntObjectHashMap();
            ourProfileCache.put(dupInfo, (TIntObjectHashMap<DuplicatesProfile>)patternCache);
        }
        if ((result = (DuplicatesProfile)patternCache.get(index)) == null) {
            DuplicatesProfile theProfile = null;
            for (DuplicatesProfile profile2 : DuplicatesProfile.EP_NAME.getExtensionList()) {
                if (!profile2.isMyDuplicate(dupInfo, index)) continue;
                theProfile = profile2;
                break;
            }
            result = theProfile == null ? NULL_PROFILE : theProfile;
            patternCache.put(index, (Object)result);
        }
        return result == NULL_PROFILE ? null : result;
    }
}

