/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.equivalence;

import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceDescriptorBuilder
implements EquivalenceDescriptor {
    private final List<SingleChildDescriptor> mySingleChildDescriptors = new ArrayList<SingleChildDescriptor>();
    private final List<MultiChildDescriptor> myMultiChildDescriptors = new ArrayList<MultiChildDescriptor>();
    private final List<Object> myConstants = new ArrayList<Object>();
    private final List<PsiElement[]> myCodeBlocks = new ArrayList<PsiElement[]>();

    @Override
    public List<SingleChildDescriptor> getSingleChildDescriptors() {
        return this.mySingleChildDescriptors;
    }

    @Override
    public List<MultiChildDescriptor> getMultiChildDescriptors() {
        return this.myMultiChildDescriptors;
    }

    @Override
    public List<Object> getConstants() {
        return this.myConstants;
    }

    @Override
    @NotNull
    public List<PsiElement[]> getCodeBlocks() {
        return this.myCodeBlocks;
    }

    public EquivalenceDescriptorBuilder codeBlock(@Nullable PsiElement[] block) {
        this.myCodeBlocks.add(block);
        return this;
    }

    public EquivalenceDescriptorBuilder element(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.DEFAULT, element);
    }

    public EquivalenceDescriptorBuilder elements(@Nullable PsiElement[] elements) {
        return this.add(MultiChildDescriptor.MyType.DEFAULT, elements);
    }

    public EquivalenceDescriptorBuilder children(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.CHILDREN, element);
    }

    @NotNull
    public EquivalenceDescriptorBuilder optionally(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.OPTIONALLY, element);
    }

    @NotNull
    public EquivalenceDescriptorBuilder optionallyInPattern(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.OPTIONALLY_IN_PATTERN, element);
    }

    @NotNull
    public EquivalenceDescriptorBuilder optionally(@Nullable PsiElement[] elements) {
        return this.add(MultiChildDescriptor.MyType.OPTIONALLY, elements);
    }

    @NotNull
    public EquivalenceDescriptorBuilder optionallyInPattern(@Nullable PsiElement[] elements) {
        return this.add(MultiChildDescriptor.MyType.OPTIONALLY_IN_PATTERN, elements);
    }

    @NotNull
    public EquivalenceDescriptorBuilder childrenOptionally(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.CHILDREN_OPTIONALLY, element);
    }

    @NotNull
    public EquivalenceDescriptorBuilder childrenOptionallyInPattern(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.CHILDREN_OPTIONALLY_IN_PATTERN, element);
    }

    @NotNull
    public EquivalenceDescriptorBuilder inAnyOrder(PsiElement[] elements) {
        return this.add(MultiChildDescriptor.MyType.IN_ANY_ORDER, elements);
    }

    @NotNull
    public EquivalenceDescriptorBuilder childrenInAnyOrder(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.CHILDREN_IN_ANY_ORDER, element);
    }

    @NotNull
    public EquivalenceDescriptorBuilder constant(@Nullable Object constant) {
        this.myConstants.add(constant);
        return this;
    }

    private EquivalenceDescriptorBuilder add(MultiChildDescriptor.MyType type, PsiElement[] elements) {
        this.myMultiChildDescriptors.add(new MultiChildDescriptor(type, elements));
        return this;
    }

    private EquivalenceDescriptorBuilder add(SingleChildDescriptor.MyType type, PsiElement element) {
        this.mySingleChildDescriptors.add(new SingleChildDescriptor(type, element));
        return this;
    }
}

