/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAddToTestsPatternAction<T extends JavaTestConfigurationBase>
extends AnAction {
    @NotNull
    protected abstract AbstractPatternBasedConfigurationProducer<T> getPatternBasedProducer();

    @NotNull
    protected abstract ConfigurationType getConfigurationType();

    protected abstract boolean isPatternBasedConfiguration(T var1);

    protected abstract Set<String> getPatterns(T var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        final LinkedHashSet<PsiElement> classes = new LinkedHashSet<PsiElement>();
        PsiElementProcessor.CollectElements processor2 = new PsiElementProcessor.CollectElements(classes);
        this.getPatternBasedProducer().collectTestMembers(psiElements, true, true, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        List<T> patternConfigurations = this.collectPatternConfigurations(classes, project2);
        if (patternConfigurations.size() == 1) {
            JavaTestConfigurationBase configuration = (JavaTestConfigurationBase)patternConfigurations.get(0);
            for (PsiElement aClass : classes) {
                this.getPatterns(configuration).add(this.getPatternBasedProducer().getQName(aClass));
            }
        } else {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<T>("Choose suite to add", patternConfigurations){

                public PopupStep onChosen(T configuration, boolean finalChoice) {
                    for (PsiElement aClass : classes) {
                        AbstractAddToTestsPatternAction.this.getPatterns(configuration).add(AbstractAddToTestsPatternAction.this.getPatternBasedProducer().getQName(aClass));
                    }
                    return FINAL_CHOICE;
                }

                public Icon getIconFor(T configuration) {
                    return configuration.getIcon();
                }

                @NotNull
                public String getTextFor(T value) {
                    return value.getName();
                }
            }).showInBestPositionFor(dataContext);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setVisible(false);
        DataContext dataContext = e.getDataContext();
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (psiElements != null) {
            List<T> foundConfigurations;
            PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(2);
            this.getPatternBasedProducer().collectTestMembers(psiElements, false, false, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
            Collection collection = processor2.getCollection();
            if (collection.isEmpty()) {
                return;
            }
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 != null && !(foundConfigurations = this.collectPatternConfigurations(collection, project2)).isEmpty()) {
                presentation.setVisible(true);
                if (foundConfigurations.size() == 1) {
                    presentation.setText("Add to temp suite: " + ((JavaTestConfigurationBase)foundConfigurations.get(0)).getName());
                }
            }
        }
    }

    private List<T> collectPatternConfigurations(Collection<PsiElement> foundClasses, Project project2) {
        List configurations = RunManager.getInstance((Project)project2).getConfigurationsList(this.getConfigurationType());
        ArrayList<JavaTestConfigurationBase> foundConfigurations = new ArrayList<JavaTestConfigurationBase>();
        for (RunConfiguration configuration : configurations) {
            if (!this.isPatternBasedConfiguration((JavaTestConfigurationBase)configuration) || foundClasses.size() <= 1 && (foundClasses.size() != 1 || this.getPatterns((JavaTestConfigurationBase)configuration).contains(this.getPatternBasedProducer().getQName((PsiElement)ContainerUtil.getFirstItem(foundClasses))))) continue;
            foundConfigurations.add((JavaTestConfigurationBase)configuration);
        }
        return foundConfigurations;
    }
}

