/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.util.PathsList;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationCommandLineState<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element> & ConfigurationWithCommandLineShortener>
extends BaseJavaApplicationCommandLineState<T> {
    public ApplicationCommandLineState(@NotNull T configuration, ExecutionEnvironment environment) {
        super(environment, configuration);
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        String jreHome;
        JavaParameters params = new JavaParameters();
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)this.getConfiguration();
        params.setMainClass(((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).getRunClass());
        this.setupJavaParameters(params);
        JavaRunConfigurationModule module2 = (JavaRunConfigurationModule)((ModuleBasedConfiguration)this.myConfiguration).getConfigurationModule();
        String string = jreHome = ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).getAlternativeJrePath() : null;
        if (module2.getModule() != null) {
            DumbService.getInstance((Project)module2.getProject()).runWithAlternativeResolveEnabled(() -> {
                int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)module2, ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).getRunClass(), false, this.isProvidedScopeIncluded());
                JavaParametersUtil.configureModule((RunConfigurationModule)module2, params, classPathType, jreHome);
            });
        } else {
            JavaParametersUtil.configureProject(module2.getProject(), params, 7, jreHome);
        }
        ApplicationCommandLineState.setupModulePath(params, module2);
        params.setShortenCommandLine(((ConfigurationWithCommandLineShortener)configuration).getShortenCommandLine(), configuration.getProject());
        return params;
    }

    @Override
    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        GeneralCommandLine line = super.createCommandLine();
        Map content = (Map)line.getUserData(JdkUtil.COMMAND_LINE_CONTENT);
        if (content != null) {
            content.forEach((key, value) -> this.addConsoleFilters(new Filter[]{new ArgumentFileFilter(key, value)}));
        }
        return line;
    }

    @Override
    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler processHandler = super.startProcess();
        if (processHandler instanceof KillableProcessHandler && DebuggerSettings.getInstance().KILL_PROCESS_IMMEDIATELY) {
            ((KillableProcessHandler)processHandler).setShouldKillProcessSoftly(false);
        }
        return processHandler;
    }

    private static void setupModulePath(JavaParameters params, JavaRunConfigurationModule module2) {
        PsiJavaModule mainModule;
        if (JavaSdkUtil.isJdkAtLeast((Sdk)params.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_9) && (mainModule = (PsiJavaModule)DumbService.getInstance((Project)module2.getProject()).computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findDescriptorByElement((PsiElement)module2.findClass(params.getMainClass())))) != null) {
            boolean inLibrary;
            boolean bl = inLibrary = mainModule instanceof PsiCompiledElement || mainModule instanceof LightJavaModule;
            if (!inLibrary || JavaModuleGraphUtil.findDescriptorByModule((Module)module2.getModule(), (boolean)false) != null) {
                params.setModuleName(mainModule.getName());
                PathsList classPath = params.getClassPath();
                PathsList modulePath = params.getModulePath();
                modulePath.addAll(classPath.getPathList());
                classPath.clear();
            }
        }
    }

    protected abstract boolean isProvidedScopeIncluded();
}

