/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.jshell.JShellHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

class DropJShellStateAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.jshell.ExecuteJShellAction");
    private static final AnAction ourInstance = new DropJShellStateAction();

    private DropJShellStateAction() {
        super("Drop All Code Snippets", "Invalidate all code snippets in the associated JShell instance", AllIcons.Actions.GC);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (vFile == null) {
            return;
        }
        try {
            JShellHandler handler = JShellHandler.getAssociatedHandler(vFile);
            if (handler != null) {
                handler.toFront();
                handler.dropState();
            }
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
    }

    public static AnAction getSharedInstance() {
        return ourInstance;
    }
}

