/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.jshell.ExecuteJShellAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public final class JShellRootType
extends ConsoleRootType {
    public static final String CONTENT_ID = "jshell_console";

    public JShellRootType() {
        super("jshell", "JShell Console");
    }

    @NotNull
    public static JShellRootType getInstance() {
        return (JShellRootType)JShellRootType.findByClass(JShellRootType.class);
    }

    @NotNull
    public String getDefaultFileExtension() {
        return "snippet";
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        assert (id == CONTENT_ID);
        return CONTENT_ID;
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            ExecuteJShellAction.getSharedInstance().registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, fileEditor.getComponent());
        }
    }
}

