/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.JShellHandler;
import com.intellij.execution.jshell.JShellRootType;
import com.intellij.execution.jshell.SnippetEditorDecorator;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class LaunchJShellConsoleAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        VirtualFile contentFile = ConsoleHistoryController.getContentFile((ConsoleRootType)JShellRootType.getInstance(), (String)"jshell_console", (ScratchFileService.Option)ScratchFileService.Option.create_new_always);
        assert (contentFile != null);
        try {
            FileEditor[] editors = FileEditorManager.getInstance((Project)project2).openFile(contentFile, true);
            Sdk alternateSdk = null;
            Module module2 = null;
            for (FileEditor editor : editors) {
                SnippetEditorDecorator.ConfigurationPane config = SnippetEditorDecorator.getJShellConfiguration(editor);
                if (config == null) continue;
                alternateSdk = config.getRuntimeSdk();
                module2 = config.getContextModule();
                break;
            }
            JShellHandler.create(project2, contentFile, module2, alternateSdk);
        }
        catch (Exception ex) {
            JShellDiagnostic.notifyError(ex, project2);
        }
    }
}

