/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class LocationUtil {
    public static boolean isJarAttached(@NotNull Location location, @NotNull PsiPackage aPackage, String ... fqn) {
        return LocationUtil.isJarAttached(location, aPackage.getDirectories(), fqn);
    }

    public static boolean isJarAttached(@NotNull Location location, PsiDirectory[] directories, String ... fqns) {
        Project project2 = location.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        Module locationModule = location.getModule();
        VirtualFile locationVirtualFile = location.getVirtualFile();
        if (locationModule != null && !Comparing.equal((String)project2.getBasePath(), (String)(locationVirtualFile != null ? locationVirtualFile.getPath() : null))) {
            for (String fqn : fqns) {
                if (facade.findClass(fqn, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)locationModule, (boolean)true)) == null) continue;
                return true;
            }
        } else {
            for (PsiDirectory directory : directories) {
                Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project2);
                if (module2 == null) continue;
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2, (boolean)true);
                for (String fqn : fqns) {
                    if (facade.findClass(fqn, scope) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

