/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodLocation
extends Location<PsiMethod> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.info.MethodLocation");
    private final Project myProject;
    @NotNull
    private final PsiMethod myMethod;
    private final Location<? extends PsiClass> myClassLocation;

    public MethodLocation(@NotNull Project project2, @NotNull PsiMethod method, @NotNull Location<? extends PsiClass> classLocation) {
        this.myProject = project2;
        this.myMethod = method;
        this.myClassLocation = classLocation;
    }

    public static MethodLocation elementInClass(PsiMethod psiElement, PsiClass psiClass) {
        Location classLocation = PsiLocation.fromPsiElement((PsiElement)psiClass);
        return new MethodLocation(classLocation.getProject(), psiElement, (Location<? extends PsiClass>)classLocation);
    }

    @NotNull
    public PsiMethod getPsiElement() {
        return this.myMethod;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public Module getModule() {
        return this.myClassLocation.getModule();
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.myClassLocation.getPsiElement();
    }

    @NotNull
    public <T extends PsiElement> Iterator<Location<T>> getAncestors(final Class<T> ancestorClass, boolean strict) {
        final Iterator fromClass = this.myClassLocation.getAncestors(ancestorClass, false);
        if (strict) {
            return fromClass;
        }
        return new Iterator<Location<T>>(){
            private boolean myFirstStep;
            {
                this.myFirstStep = ancestorClass.isInstance(MethodLocation.this.myMethod);
            }

            @Override
            public boolean hasNext() {
                return this.myFirstStep || fromClass.hasNext();
            }

            @Override
            public Location<T> next() {
                MethodLocation location = this.myFirstStep ? MethodLocation.this : (Location)fromClass.next();
                this.myFirstStep = false;
                return location;
            }

            @Override
            public void remove() {
                LOG.assertTrue(false);
            }
        };
    }
}

