/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/remote/JavaRemoteDebugRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "()V", "canImport", "", "typeName", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "intellij.java.execution.impl"})
public final class JavaRemoteDebugRunConfigurationImporter
implements RunConfigurationImporter {
    public void process(@NotNull Project project2, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, ?> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (!(runConfiguration instanceof RemoteConfiguration)) {
            throw (Throwable)new IllegalArgumentException("Unexpected type of run configuration: " + runConfiguration.getClass());
        }
        ObjectUtils.consumeIfCast(cfg.get("moduleName"), String.class, (Consumer)new Consumer<T>(modelsProvider, runConfiguration){
            final /* synthetic */ IdeModifiableModelsProvider $modelsProvider;
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                Module module2 = this.$modelsProvider.getModifiableModuleModel().findModuleByName(it);
                if (module2 != null) {
                    ((RemoteConfiguration)this.$runConfiguration).setModule(module2);
                }
            }
            {
                this.$modelsProvider = ideModifiableModelsProvider;
                this.$runConfiguration = runConfiguration;
            }
        });
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)runConfiguration;
        Object obj = cfg.get("transport");
        if (!(obj instanceof String)) {
            obj = null;
        }
        remoteConfiguration.USE_SOCKET_TRANSPORT = Intrinsics.areEqual((Object)((String)obj), (Object)"SHARED_MEM") ^ true;
        RemoteConfiguration remoteConfiguration2 = (RemoteConfiguration)runConfiguration;
        Object obj2 = cfg.get("mode");
        if (!(obj2 instanceof String)) {
            obj2 = null;
        }
        remoteConfiguration2.SERVER_MODE = Intrinsics.areEqual((Object)((String)obj2), (Object)"LISTEN");
        ObjectUtils.consumeIfCast(cfg.get("port"), Number.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(Number it) {
                ((RemoteConfiguration)this.$runConfiguration).PORT = String.valueOf(it.intValue());
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("host"), String.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                ((RemoteConfiguration)this.$runConfiguration).HOST = it;
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("sharedMemoryAddress"), String.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                ((RemoteConfiguration)this.$runConfiguration).SHMEM_ADDRESS = it;
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
    }

    public boolean canImport(@NotNull String typeName) {
        return Intrinsics.areEqual((Object)typeName, (Object)"remote");
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return ((RemoteConfigurationType)ConfigurationTypeUtil.findConfigurationType(RemoteConfigurationType.class)).getConfigurationFactories()[0];
    }
}

