/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProcessProxyImpl;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.execution.application.AppMainV2;
import com.intellij.util.PathsList;
import java.io.File;

public class ProcessProxyFactoryImpl
extends ProcessProxyFactory {
    private static final boolean ourMayUseLauncher = !Boolean.getBoolean("idea.no.launcher");

    public ProcessProxy createCommandLineProxy(JavaCommandLine javaCmdLine) throws ExecutionException {
        JavaParameters javaParameters = javaCmdLine.getJavaParameters();
        String mainClass = javaParameters.getMainClass();
        if (ourMayUseLauncher && mainClass != null) {
            boolean runtimeJarFile;
            String rtJarPath = JavaSdkUtil.getIdeaRtJarPath();
            boolean bl = runtimeJarFile = new File(rtJarPath).isFile() && FileUtil.isAncestor((String)PathManager.getHomePath(), (String)rtJarPath, (boolean)true);
            if (runtimeJarFile || javaParameters.getModuleName() == null) {
                try {
                    ProcessProxyImpl proxy = new ProcessProxyImpl(StringUtil.getShortName((String)mainClass));
                    String port = String.valueOf(proxy.getPortNumber());
                    String binPath = proxy.getBinPath();
                    if (runtimeJarFile && JavaSdkUtil.isJdkAtLeast((Sdk)javaParameters.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_5)) {
                        javaParameters.getVMParametersList().add("-javaagent:" + rtJarPath + '=' + port + ':' + binPath);
                    } else {
                        JavaSdkUtil.addRtJar((PathsList)javaParameters.getClassPath());
                        ParametersList vmParametersList = javaParameters.getVMParametersList();
                        vmParametersList.defineProperty("idea.launcher.port", port);
                        vmParametersList.defineProperty("idea.launcher.bin.path", binPath);
                        javaParameters.getProgramParametersList().prepend(mainClass);
                        javaParameters.setMainClass(AppMainV2.class.getName());
                    }
                    return proxy;
                }
                catch (Exception e) {
                    Logger.getInstance(ProcessProxy.class).warn((Throwable)e);
                }
            }
        }
        return null;
    }

    public ProcessProxy getAttachedProxy(ProcessHandler processHandler) {
        return (ProcessProxy)ProcessProxyImpl.KEY.get((UserDataHolder)processHandler);
    }
}

