/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class JavaScratchCompilationSupport
implements CompileTask {
    public JavaScratchCompilationSupport(@NotNull Project project2) {
        CompilerManager.getInstance((Project)project2).addAfterTask((CompileTask)this);
    }

    @Nullable
    public static File getScratchOutputDirectory(Project project2) {
        File root = CompilerManager.getInstance((Project)project2).getJavacCompilerWorkingDir();
        return root != null ? new File(root, "scratches/out") : null;
    }

    @Nullable
    public static File getScratchTempDirectory(Project project2) {
        File root = CompilerManager.getInstance((Project)project2).getJavacCompilerWorkingDir();
        return root != null ? new File(root, "scratches/src") : null;
    }

    public boolean execute(CompileContext context) {
        Sdk targetSdk;
        Project project2 = context.getProject();
        RunConfiguration configuration = CompileStepBeforeRun.getRunConfiguration(context);
        if (!(configuration instanceof JavaScratchConfiguration)) {
            return true;
        }
        JavaScratchConfiguration scratchConfig = (JavaScratchConfiguration)configuration;
        String scratchUrl = scratchConfig.getScratchFileUrl();
        if (scratchUrl == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Associated scratch file not found", null, -1, -1);
            return false;
        }
        Module module2 = ((JavaRunConfigurationModule)scratchConfig.getConfigurationModule()).getModule();
        Sdk sdk = targetSdk = module2 != null ? ModuleRootManager.getInstance((Module)module2).getSdk() : ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (targetSdk == null) {
            String message = module2 != null ? "Cannot find associated SDK for run configuration module \"" + module2.getName() + "\".\nPlease check project settings." : "Cannot find associated project SDK for the run configuration.\nPlease check project settings.";
            context.addMessage(CompilerMessageCategory.ERROR, message, scratchUrl, -1, -1);
            return true;
        }
        if (!(targetSdk.getSdkType() instanceof JavaSdkType)) {
            String message = module2 != null ? "Expected Java SDK for run configuration module \"" + module2.getName() + "\".\nPlease check project settings." : "Expected Java SDK for project \"" + project2.getName() + "\".\nPlease check project settings.";
            context.addMessage(CompilerMessageCategory.ERROR, message, scratchUrl, -1, -1);
            return true;
        }
        File outputDir = JavaScratchCompilationSupport.getScratchOutputDirectory(project2);
        if (outputDir == null) {
            return true;
        }
        FileUtil.delete((File)outputDir);
        try {
            File scratchFile;
            File srcFile = scratchFile = new File(VirtualFileManager.extractPath((String)scratchUrl));
            if (!StringUtil.endsWith((CharSequence)srcFile.getName(), (CharSequence)".java")) {
                File srcDir = JavaScratchCompilationSupport.getScratchTempDirectory(project2);
                if (srcDir == null) {
                    return true;
                }
                FileUtil.delete((File)srcDir);
                String srcFileName = (String)ReadAction.compute(() -> {
                    PsiFile psiFile;
                    VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(scratchUrl);
                    if (vFile != null && (psiFile = PsiManager.getInstance((Project)project2).findFile(vFile)) instanceof PsiJavaFile) {
                        String name2 = null;
                        for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                            if (name2 == null) {
                                name2 = aClass.getName();
                                if (!JavaScratchCompilationSupport.isPublic(aClass)) continue;
                                break;
                            }
                            if (!JavaScratchCompilationSupport.isPublic(aClass)) continue;
                            name2 = aClass.getName();
                            break;
                        }
                        if (name2 != null) {
                            return name2;
                        }
                    }
                    return FileUtil.getNameWithoutExtension((File)scratchFile);
                });
                srcFile = new File(srcDir, srcFileName + ".java");
                FileUtil.copy((File)scratchFile, (File)srcFile);
            }
            Set<File> files = Collections.singleton(srcFile);
            LinkedHashSet cp = new LinkedHashSet();
            ArrayList platformCp = new ArrayList();
            Computable orderEnumerator = module2 != null ? () -> ModuleRootManager.getInstance((Module)module2).orderEntries() : () -> ProjectRootManager.getInstance((Project)project2).orderEntries();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (module2 != null || scratchConfig.isBuildProjectOnEmptyModuleList()) {
                    for (String s : ((OrderEnumerator)orderEnumerator.compute()).compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
                        cp.add(new File(s));
                    }
                }
                for (String s : ((OrderEnumerator)orderEnumerator.compute()).compileOnly().sdkOnly().getPathsList().getPathList()) {
                    platformCp.add(new File(s));
                }
            });
            ArrayList<String> options = new ArrayList<String>();
            options.add("-g");
            JavaSdkVersion sdkVersion = JavaSdk.getInstance().getVersion(targetSdk);
            if (sdkVersion != null) {
                LanguageLevel level = sdkVersion.getMaxLanguageLevel();
                String langLevel = JpsJavaSdkType.complianceOption((JavaVersion)level.toJavaVersion());
                options.add("-source");
                options.add(langLevel);
                options.add("-target");
                options.add(langLevel);
                if (level.isPreview()) {
                    options.add("--enable-preview");
                }
            }
            options.add("-proc:none");
            Collection result = CompilerManager.getInstance((Project)project2).compileJavaCode(options, platformCp, cp, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), files, outputDir);
            for (ClassObject classObject : result) {
                byte[] bytes = classObject.getContent();
                if (bytes == null) continue;
                FileUtil.writeToFile((File)new File(classObject.getPath()), (byte[])bytes);
            }
        }
        catch (CompilationException e) {
            for (CompilationException.Message m : e.getMessages()) {
                context.addMessage(m.getCategory(), m.getText(), scratchUrl, m.getLine(), m.getColumn());
            }
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), scratchUrl, -1, -1);
        }
        return true;
    }

    private static boolean isPublic(PsiClass aClass) {
        PsiModifierList modifiers = aClass.getModifierList();
        return modifiers != null && modifiers.hasModifierProperty("public");
    }
}

