/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.annotations.SerializedName;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijTestDiscoveryProducer
implements TestDiscoveryProducer {
    private static final String INTELLIJ_TEST_DISCOVERY_HOST = "https://intellij-test-discovery.labs.intellij.net";

    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project project2, @NotNull List<Couple<String>> classesAndMethods, byte frameworkId) {
        if (!ApplicationManager.getApplication().isInternal()) {
            return MultiMap.empty();
        }
        try {
            List bareClasses = ContainerUtil.newSmartList();
            List allTogether = ContainerUtil.newSmartList();
            classesAndMethods.forEach(couple -> {
                if (couple.second == null) {
                    bareClasses.add(couple.first);
                } else {
                    allTogether.add(couple);
                }
            });
            MultiMap result = new MultiMap();
            result.putAllValues(IntellijTestDiscoveryProducer.request(allTogether, couple -> "\"" + (String)couple.first + "." + (String)couple.second + "\"", "methods"));
            result.putAllValues(IntellijTestDiscoveryProducer.request(bareClasses, s -> "\"" + s + "\"", "classes"));
            return result;
        }
        catch (HttpRequests.HttpStatusException http) {
            LOG.debug("No tests found", (Throwable)http);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        return MultiMap.empty();
    }

    @NotNull
    private static <T> MultiMap<String, String> request(List<T> collection, Function<? super T, String> toString, String what) throws IOException {
        if (collection.isEmpty()) {
            return MultiMap.empty();
        }
        String url = "https://intellij-test-discovery.labs.intellij.net/search/tests/by-" + what;
        LOG.debug(url);
        return (MultiMap)HttpRequests.post((String)url, (String)"application/json").productNameAsUserAgent().gzip(true).connect(r -> {
            r.write(collection.stream().map(toString).collect(Collectors.joining(",", "[", "]")));
            TestsSearchResult search = (TestsSearchResult)new ObjectMapper().readValue(r.getInputStream(), TestsSearchResult.class);
            MultiMap result = new MultiMap();
            search.getTests().forEach((classFqn, testMethodName) -> result.putValues(classFqn, (Collection)testMethodName));
            return result;
        });
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTestsForFiles(@NotNull Project project2, @NotNull List<String> filePaths, byte frameworkId) {
        try {
            return IntellijTestDiscoveryProducer.request(filePaths, s -> "\"" + s + "\"", "files");
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return MultiMap.empty();
        }
    }

    @Override
    @NotNull
    public List<String> getAffectedFilePaths(@NotNull Project project2, @NotNull List<Couple<String>> testFqns, byte frameworkId) throws IOException {
        String url = "https://intellij-test-discovery.labs.intellij.net/search/test/details";
        return IntellijTestDiscoveryProducer.executeQuery((ThrowableComputable<List<String>, IOException>)((ThrowableComputable)() -> (List)HttpRequests.post((String)url, (String)"application/json").productNameAsUserAgent().gzip(true).connect(r -> {
            r.write(testFqns.stream().map(s -> "\"" + (String)s.getFirst() + "." + (String)s.getSecond() + "\"").collect(Collectors.joining(",", "[", "]")));
            return Arrays.stream((Object[])new ObjectMapper().readValue(r.getInputStream(), TestDetails[].class)).map(details -> ((TestDetails)details).files).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        })), project2);
    }

    @Override
    @NotNull
    public List<String> getAffectedFilePathsByClassName(@NotNull Project project2, @NotNull String testClassName, byte frameworkId) throws IOException {
        String url = "https://intellij-test-discovery.labs.intellij.net/search/files/affected/by-test-classes";
        return IntellijTestDiscoveryProducer.executeQuery((ThrowableComputable<List<String>, IOException>)((ThrowableComputable)() -> (List)HttpRequests.post((String)url, (String)"application/json").productNameAsUserAgent().gzip(true).connect(r -> {
            r.write("[\"" + testClassName + "\"]");
            Map map2 = (Map)new ObjectMapper().readValue(r.getInputStream(), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
            return (List)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(map2.values()), Collections.emptyList());
        })), project2);
    }

    @Override
    @NotNull
    public List<String> getFilesWithoutTests(@NotNull Project project2, @NotNull Collection<String> paths) throws IOException {
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        String url = "https://intellij-test-discovery.labs.intellij.net/search/files-without-related-tests";
        LOG.debug(url);
        return (List)HttpRequests.post((String)url, (String)"application/json").productNameAsUserAgent().gzip(true).connect(r -> {
            r.write(paths.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(",", "[", "]")));
            return (List)new ObjectMapper().readValue(r.getInputStream(), (TypeReference)new TypeReference<List<String>>(){});
        });
    }

    @NotNull
    private static List<String> executeQuery(final @NotNull ThrowableComputable<List<String>, IOException> query, @NotNull Project project2) throws IOException {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            List result = (List)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<List<String>, IOException>(project2, "Searching for Affected File Paths...", true){

                protected List<String> compute(@NotNull ProgressIndicator indicator) throws IOException {
                    return (List)query.compute();
                }
            });
            return result == null ? Collections.emptyList() : result;
        }
        return (List)query.compute();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private static class TestDetails {
        @Nullable
        private String method;
        @SerializedName(value="class")
        @JsonProperty(value="class")
        @Nullable
        private String className;
        @Nullable
        private List<String> files = ContainerUtil.newSmartList();
        @Nullable
        private String message;

        private TestDetails() {
        }

        @Nullable
        public String getMethod() {
            return this.method;
        }

        public TestDetails setMethod(String method) {
            this.method = method;
            return this;
        }

        @Nullable
        public String getClassName() {
            return this.className;
        }

        public TestDetails setClassName(String name2) {
            this.className = name2;
            return this;
        }

        @NotNull
        public List<String> getFiles() {
            if (this.files == null) {
                return Collections.emptyList();
            }
            return this.files;
        }

        public TestDetails setFiles(@NotNull List<String> files) {
            this.files = files;
            return this;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        public TestDetails setMessage(String message) {
            this.message = message;
            return this;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TestsSearchResult {
        @Nullable
        private String method;
        @SerializedName(value="class")
        @JsonProperty(value="class")
        @Nullable
        private String className;
        private int found;
        @NotNull
        private Map<String, List<String>> tests = new HashMap<String, List<String>>();
        @Nullable
        private String message;

        @Nullable
        public String getMethod() {
            return this.method;
        }

        public TestsSearchResult setMethod(String method) {
            this.method = method;
            return this;
        }

        @Nullable
        public String getClassName() {
            return this.className;
        }

        public TestsSearchResult setClassName(String name2) {
            this.className = name2;
            return this;
        }

        public int getFound() {
            return this.found;
        }

        public TestsSearchResult setFound(int found2) {
            this.found = found2;
            return this;
        }

        @NotNull
        public Map<String, List<String>> getTests() {
            return this.tests;
        }

        public TestsSearchResult setTests(@NotNull Map<String, List<String>> tests) {
            this.tests = tests;
            return this;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        public TestsSearchResult setMessage(String message) {
            this.message = message;
            return this;
        }
    }
}

