/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LocalTestDiscoveryProducer
implements TestDiscoveryProducer {
    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project project2, @NotNull List<Couple<String>> classesAndMethods, byte frameworkId) {
        MultiMap result = new MultiMap();
        TestDiscoveryIndex instance2 = TestDiscoveryIndex.getInstance(project2);
        classesAndMethods.forEach(couple -> result.putAllValues(couple.second == null ? instance2.getTestsByClassName((String)couple.first, frameworkId) : instance2.getTestsByMethodName((String)couple.first, (String)couple.second, frameworkId)));
        return result;
    }

    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTestsForFiles(@NotNull Project project2, @NotNull List<String> paths, byte frameworkId) {
        MultiMap result = new MultiMap();
        TestDiscoveryIndex instance2 = TestDiscoveryIndex.getInstance(project2);
        for (String path : paths) {
            result.putAllValues(instance2.getTestsByFile(path, frameworkId));
        }
        return result;
    }

    @Override
    @NotNull
    public List<String> getAffectedFilePaths(@NotNull Project project2, @NotNull List<Couple<String>> testFqns, byte frameworkId) {
        TestDiscoveryIndex instance2 = TestDiscoveryIndex.getInstance(project2);
        HashSet<String> result = new HashSet<String>();
        for (Couple<String> test : testFqns) {
            result.addAll(instance2.getAffectedFiles(test, frameworkId));
        }
        return ContainerUtil.newArrayList(result);
    }

    @Override
    @NotNull
    public List<String> getAffectedFilePathsByClassName(@NotNull Project project2, @NotNull String testClassName, byte frameworkId) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<String> getFilesWithoutTests(@NotNull Project project2, @NotNull Collection<String> paths) {
        return Collections.emptyList();
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

