/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiscoveredTestsTreeModel
extends BaseTreeModel<Object> {
    private final Object myRoot = ObjectUtils.NULL;
    private final List<Node.Clazz> myTestClasses = new SmartList();
    private final Map<Node.Clazz, List<Node.Method>> myTests = new HashMap<Node.Clazz, List<Node.Method>>();

    DiscoveredTestsTreeModel() {
    }

    public synchronized List<?> getChildren(Object parent) {
        if (parent == this.myRoot) {
            return this.getTestClasses();
        }
        if (parent instanceof Node.Clazz) {
            return ContainerUtil.newArrayList((Iterable)this.myTests.get((Node.Clazz)parent));
        }
        return Collections.emptyList();
    }

    synchronized List<Node<PsiClass>> getTestClasses() {
        return ContainerUtil.newArrayList(this.myTestClasses);
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public boolean isLeaf(Object object) {
        return this.myRoot != object && super.isLeaf(object);
    }

    synchronized void addTest(@NotNull PsiClass testClass, @Nullable PsiMethod testMethod, @Nullable String parameter) {
        Node.Method actualMethodNode;
        int methodIdx;
        Node.Clazz classNode = (Node.Clazz)ReadAction.compute(() -> new Node.Clazz(testClass));
        Node.Method methodNode = testMethod == null ? null : (Node.Method)ReadAction.compute(() -> new Node.Method(testMethod));
        int idx = (Integer)ReadAction.compute(() -> Collections.binarySearch(this.myTestClasses, classNode, Comparator.comparing(c -> c.getName()).thenComparing(c -> c.getPackageName())));
        if (idx < 0) {
            int insertIdx = -idx - 1;
            this.myTestClasses.add(insertIdx, classNode);
            this.myTests.put(classNode, methodNode == null ? ContainerUtil.newSmartList() : ContainerUtil.newSmartList((Object)methodNode));
            this.treeStructureChanged(null, null, null);
            return;
        }
        List<Node.Method> testMethods = this.myTests.get(this.myTestClasses.get(idx));
        int n = methodIdx = methodNode != null ? (Integer)ReadAction.compute(() -> Collections.binarySearch(testMethods, methodNode, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName())))) : -1;
        if (methodIdx < 0) {
            methodIdx = -methodIdx - 1;
            if (methodNode != null) {
                testMethods.add(methodIdx, methodNode);
            }
            actualMethodNode = methodNode;
        } else {
            actualMethodNode = testMethods.get(methodIdx);
        }
        if (actualMethodNode != null && parameter != null) {
            actualMethodNode.addParameter(parameter);
        }
        this.treeStructureChanged(null, null, null);
    }

    @Nullable
    public static String getClassName(@NotNull PsiClass c) {
        PsiClass containingClass;
        if (c instanceof PsiAnonymousClass && (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)c, PsiClass.class)) != null) {
            return ClassUtil.getJVMClassName((PsiClass)containingClass) + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)c));
        }
        return ClassUtil.getJVMClassName((PsiClass)c);
    }

    @NotNull
    synchronized TestMethodUsage[] getTestMethods() {
        return (TestMethodUsage[])this.myTests.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(m -> new TestMethodUsage(m.getPointer(), ((Node.Clazz)e.getKey()).getPointer(), m.getParameters()))).toArray(TestMethodUsage[]::new);
    }

    synchronized int getTestCount() {
        return this.myTests.values().stream().mapToInt(ms -> ms.size()).sum();
    }

    synchronized int getTestClassesCount() {
        return this.myTests.size();
    }

    public static abstract class Node<Psi extends PsiMember> {
        @NotNull
        private final SmartPsiElementPointer<Psi> myPointer;
        private final String myName;
        private final Icon myIcon;

        private Node(@NotNull Psi psi) {
            this(psi, o -> o.getName());
        }

        public Node(@NotNull Psi psi, Function<? super Psi, String> calcName) {
            this.myPointer = SmartPointerManager.createPointer(psi);
            this.myName = (String)calcName.fun(psi);
            this.myIcon = psi.getIcon(2);
        }

        @NotNull
        public SmartPsiElementPointer<Psi> getPointer() {
            return this.myPointer;
        }

        String getName() {
            return this.myName;
        }

        Icon getIcon() {
            return this.myIcon;
        }

        /* synthetic */ Node(PsiMember x0, 1 x1) {
            this(x0);
        }

        static class Method
        extends Node<PsiMethod> {
            private final Collection<String> myParameters = new THashSet();

            private Method(@NotNull PsiMethod method) {
                super((PsiMember)method, null);
            }

            public void addParameter(@NotNull String parameter) {
                this.myParameters.add(parameter);
            }

            @NotNull
            Collection<String> getParameters() {
                return this.myParameters;
            }
        }

        static class Clazz
        extends Node<PsiClass> {
            private final String myPackageName;

            Clazz(@NotNull PsiClass psi) {
                super(psi, o -> StringUtil.notNullize((String)o.getName(), (String)StringUtil.notNullize((String)DiscoveredTestsTreeModel.getClassName(o), (String)"<null>")));
                this.myPackageName = PsiUtil.getPackageName((PsiClass)psi);
            }

            String getPackageName() {
                return this.myPackageName;
            }
        }
    }
}

