/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.testDiscovery.IntellijTestDiscoveryProducer;
import com.intellij.execution.testDiscovery.actions.ShowAffectedTestsAction;
import com.intellij.find.FindUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FindUnusedTestDataAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(FindUnusedTestDataAction.class);

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] roots = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = e.getProject();
        e.getPresentation().setEnabled(roots != null && roots.length > 0 && project2 != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] roots = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = e.getProject();
        assert (project2 != null);
        assert (roots != null && roots.length > 0);
        VirtualFile projectBasePath = ShowAffectedTestsAction.getBasePathAsVirtualFile(project2);
        if (projectBasePath == null) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            Set paths = JBIterable.of((Object[])roots).flatMap(f -> VfsUtil.collectChildrenRecursively((VirtualFile)f)).map(f -> VcsFileUtil.getRelativeFilePath((VirtualFile)f, (VirtualFile)projectBasePath)).filter(Objects::nonNull).map(p -> "/" + p).toSet();
            try {
                List<String> filesWithoutTests = new IntellijTestDiscoveryProducer().getFilesWithoutTests(project2, paths);
                if (!filesWithoutTests.isEmpty()) {
                    VirtualFileManager vfm = VirtualFileManager.getInstance();
                    PsiManager psiManager = PsiManager.getInstance((Project)project2);
                    String basePath = projectBasePath.getPath();
                    application.runReadAction(() -> {
                        PsiFile[] files = JBIterable.of((Object)filesWithoutTests).flatten(FunctionUtil.id()).map(f -> vfm.refreshAndFindFileByUrl("file://" + basePath + f)).map(arg_0 -> ((PsiManager)psiManager).findFile(arg_0)).filter(Objects::nonNull).toSet().toArray(PsiFile.EMPTY_ARRAY);
                        if (files.length == 0) {
                            FindUnusedTestDataAction.nothingToDo();
                        } else {
                            application.invokeLater(() -> FindUtil.showInUsageView(null, (Object[])files, file -> new UsageInfo2UsageAdapter(new UsageInfo(file)), (String)"Unused Test Data", p -> {
                                p.setCodeUsages(false);
                                p.setUsagesWord("file");
                            }, (Project)project2));
                        }
                    });
                } else {
                    FindUnusedTestDataAction.nothingToDo();
                }
            }
            catch (IOException io) {
                LOG.warn((Throwable)io);
            }
        });
    }

    private static void nothingToDo() {
        Notifications.Bus.notify((Notification)new Notification(FindUnusedTestDataAction.class.getName(), "Well done", "Every file is used", NotificationType.INFORMATION));
    }
}

