/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.testDiscovery.TestDiscoveryConfigurationProducer;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.execution.testDiscovery.actions.DiscoveredTestsTree;
import com.intellij.execution.testDiscovery.actions.DiscoveredTestsTreeModel;
import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.uast.UastMetaLanguage;
import com.intellij.ui.ActiveComponent;
import com.intellij.usages.UsageView;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.vcsUtil.VcsFileUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class ShowAffectedTestsAction
extends AnAction {
    private static final String RUN_ALL_ACTION_TEXT = "Run All Affected Tests";

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(ShowAffectedTestsAction.isEnabled(e.getProject()) && (ShowAffectedTestsAction.findMethodAtCaret(e) != null || ShowAffectedTestsAction.findClassAtCaret(e) != null || !ShowAffectedTestsAction.findFilesInContext(e).isEmpty() || e.getData(VcsDataKeys.CHANGES) != null));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        assert (project2 != null);
        PsiMethod method = ShowAffectedTestsAction.findMethodAtCaret(e);
        if (method != null) {
            ShowAffectedTestsAction.showDiscoveredTestsByPsiMethod(project2, method, e);
            return;
        }
        PsiClass psiClass = ShowAffectedTestsAction.findClassAtCaret(e);
        if (psiClass != null) {
            ShowAffectedTestsAction.showDiscoveredTestsByPsiClass(project2, psiClass, e);
            return;
        }
        if (e.getData(VcsDataKeys.CHANGES) != null) {
            ShowAffectedTestsAction.showDiscoveredTestsByChanges(e);
            return;
        }
        List<VirtualFile> virtualFiles = ShowAffectedTestsAction.findFilesInContext(e);
        if (!virtualFiles.isEmpty()) {
            ShowAffectedTestsAction.showDiscoveredTestsByFile(project2, virtualFiles, e);
        }
    }

    private static void showDiscoveredTestsByFile(@NotNull Project project2, @NotNull List<VirtualFile> files, @NotNull AnActionEvent e) {
        VirtualFile projectBasePath = ShowAffectedTestsAction.getBasePathAsVirtualFile(project2);
        if (projectBasePath == null) {
            return;
        }
        DiscoveredTestsTree tree = ShowAffectedTestsAction.showTree(project2, e.getDataContext(), ShowAffectedTestsAction.createTitle(files));
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            JBIterable paths = JBIterable.from((Iterable)files).flatMap(f -> VfsUtil.collectChildrenRecursively((VirtualFile)f)).map(f -> VcsFileUtil.getRelativeFilePath((VirtualFile)f, (VirtualFile)projectBasePath)).filter(Objects::nonNull).map(p -> "/" + p);
            if (paths.isNotEmpty()) {
                ShowAffectedTestsAction.processMethodsAsync(project2, PsiMethod.EMPTY_ARRAY, paths.toList(), ShowAffectedTestsAction.createTreeProcessor(tree), () -> tree.setPaintBusy(false));
            }
        });
    }

    @NotNull
    private static String createTitle(@NotNull List<VirtualFile> files) {
        if (files.isEmpty()) {
            return "Empty Selection";
        }
        String firstName = files.get(0).getName();
        if (files.size() == 1) {
            return firstName;
        }
        if (files.size() == 2) {
            return firstName + " and " + files.get(1).getName();
        }
        return firstName + " et al.";
    }

    private static void showDiscoveredTestsByPsiClass(@NotNull Project project2, @NotNull PsiClass psiClass, @NotNull AnActionEvent e) {
        if (DumbService.isDumb((Project)project2)) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Editor)e.getRequiredData(CommonDataKeys.EDITOR)).getContentComponent());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        String presentableName = PsiFormatUtil.formatClass((PsiClass)psiClass, (int)1);
        DiscoveredTestsTree tree = ShowAffectedTestsAction.showTree(project2, dataContext, presentableName);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (DumbService.isDumb((Project)project2)) {
                return;
            }
            String className = (String)ReadAction.compute(() -> DiscoveredTestsTreeModel.getClassName(psiClass));
            if (className == null) {
                return;
            }
            List classesAndMethods = ContainerUtil.newSmartList((Object)Couple.of((Object)className, null));
            ShowAffectedTestsAction.processTestDiscovery(project2, ShowAffectedTestsAction.createTreeProcessor(tree), classesAndMethods, Collections.emptyList());
            EdtInvocationManager.getInstance().invokeLater(() -> tree.setPaintBusy(false));
        });
    }

    private static void showDiscoveredTestsByPsiMethod(@NotNull Project project2, @NotNull PsiMethod method, @NotNull AnActionEvent e) {
        Couple<String> key = ShowAffectedTestsAction.getMethodKey(method);
        if (key == null) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Editor)e.getRequiredData(CommonDataKeys.EDITOR)).getContentComponent());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        String presentableName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        DiscoveredTestsTree tree = ShowAffectedTestsAction.showTree(project2, dataContext, presentableName);
        ShowAffectedTestsAction.processMethodsAsync(project2, new PsiMethod[]{method}, Collections.emptyList(), ShowAffectedTestsAction.createTreeProcessor(tree), () -> tree.setPaintBusy(false));
    }

    @NotNull
    private static TestDiscoveryProducer.PsiTestProcessor createTreeProcessor(@NotNull DiscoveredTestsTree tree) {
        return (clazz, method, parameter) -> {
            tree.addTest(clazz, method, parameter);
            return true;
        };
    }

    private static void showDiscoveredTestsByChanges(@NotNull AnActionEvent e) {
        Change[] changes = (Change[])e.getRequiredData(VcsDataKeys.CHANGES);
        Project project2 = e.getProject();
        assert (project2 != null);
        ShowAffectedTestsAction.showDiscoveredTestsByChanges(project2, changes, "Selected Changes", e.getDataContext());
    }

    public static void showDiscoveredTestsByChanges(@NotNull Project project2, @NotNull Change[] changes, @NotNull String title, @NotNull DataContext dataContext) {
        DiscoveredTestsTree tree = ShowAffectedTestsAction.showTree(project2, dataContext, title);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery.selected.changes");
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PsiMethod[] methods = ShowAffectedTestsAction.findMethods(project2, changes);
            List<String> filePaths = ShowAffectedTestsAction.getRelativeAffectedPaths(project2, Arrays.asList(changes));
            ShowAffectedTestsAction.processMethodsAsync(project2, methods, filePaths, ShowAffectedTestsAction.createTreeProcessor(tree), () -> tree.setPaintBusy(false));
        });
    }

    @NotNull
    public static PsiMethod[] findMethods(@NotNull Project project2, Change ... changes) {
        UastMetaLanguage jvmLanguage = (UastMetaLanguage)Language.findInstance(UastMetaLanguage.class);
        return (PsiMethod[])PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> (PsiMethod[])FormatChangedTextUtil.getInstance().getChangedElements(project2, changes, file -> {
            if (DumbService.isDumb((Project)project2) || project2.isDisposed() || !file.isValid()) {
                return null;
            }
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project2);
            if (!index.isInSource(file)) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
            if (psiFile == null || !jvmLanguage.matchesLanguage(psiFile.getLanguage())) {
                return null;
            }
            Document document2 = FileDocumentManager.getInstance().getDocument(file);
            if (document2 == null) {
                return null;
            }
            final List physicalMethods = ContainerUtil.newSmartList();
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    UMethod method = (UMethod)UastContextKt.toUElement((PsiElement)element, UMethod.class);
                    if (method != null) {
                        ContainerUtil.addAllNotNull((Collection)physicalMethods, (Object[])new PsiElement[]{method.getSourcePsi()});
                    }
                    super.visitElement(element);
                }
            });
            return physicalMethods;
        }).stream().map(m -> UastContextKt.toUElement((PsiElement)m)).filter(Objects::nonNull).map(m -> (PsiMethod)ObjectUtils.tryCast((Object)m.getJavaPsi(), PsiMethod.class)).filter(Objects::nonNull).toArray(arg_0 -> ((ArrayFactory)PsiMethod.ARRAY_FACTORY).create(arg_0)));
    }

    public static boolean isEnabled(@Nullable Project project2) {
        if (project2 == null || DumbService.isDumb((Project)project2)) {
            return false;
        }
        return Registry.is((String)"testDiscovery.enabled") || ApplicationManager.getApplication().isInternal();
    }

    @NotNull
    private static List<VirtualFile> findFilesInContext(@NotNull AnActionEvent event) {
        PsiFile file;
        VirtualFile[] virtualFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if ((virtualFiles == null || virtualFiles.length == 0) && (file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE)) != null) {
            virtualFiles = new VirtualFile[]{file.getVirtualFile()};
        }
        return virtualFiles == null ? Collections.emptyList() : Arrays.stream(virtualFiles).filter(v -> v.isInLocalFileSystem()).collect(Collectors.toList());
    }

    @Nullable
    private static PsiMethod findMethodAtCaret(@NotNull AnActionEvent e) {
        UMethod uMethod = (UMethod)UastUtils.findContaining((PsiElement)ShowAffectedTestsAction.findElementAtCaret(e), UMethod.class);
        return uMethod == null ? null : (PsiMethod)ObjectUtils.tryCast((Object)uMethod.getJavaPsi(), PsiMethod.class);
    }

    @Nullable
    private static PsiClass findClassAtCaret(@NotNull AnActionEvent e) {
        UClass uClass = (UClass)UastUtils.findContaining((PsiElement)ShowAffectedTestsAction.findElementAtCaret(e), UClass.class);
        return uClass == null ? null : (PsiClass)ObjectUtils.tryCast((Object)uClass.getJavaPsi(), PsiClass.class);
    }

    @Nullable
    private static PsiElement findElementAtCaret(@NotNull AnActionEvent e) {
        PsiElement prev;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || file == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        if (at instanceof PsiWhiteSpace && offset > 0 && !((prev = file.findElementAt(offset - 1)) instanceof PsiWhiteSpace)) {
            return prev;
        }
        return at;
    }

    @NotNull
    private static DiscoveredTestsTree showTree(final @NotNull Project project2, @NotNull DataContext dataContext, final @NotNull String title) {
        final DiscoveredTestsTree tree = new DiscoveredTestsTree(title);
        final String initTitle = "Tests for " + title;
        final Ref ref = new Ref();
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        ActiveComponent runButton = ShowAffectedTestsAction.createButton(RUN_ALL_ACTION_TEXT, AllIcons.Actions.Execute, () -> ShowAffectedTestsAction.runAllDiscoveredTests(project2, tree, (Ref<? extends JBPopup>)ref, context, initTitle), tree);
        Runnable pinActionListener = () -> {
            JBPopup popup;
            UsageView view = FindUtil.showInUsageView(null, (Object[])tree.getTestMethods(), param -> param, (String)initTitle, p -> {
                p.setCodeUsages(false);
                p.setUsagesWord("test");
                p.setMergeDupLinesAvailable(false);
                p.setUsageTypeFilteringAvailable(false);
                p.setExcludeAvailable(false);
            }, (Project)project2);
            if (view != null) {
                view.addButtonToLowerPane((Action)new AbstractAction(RUN_ALL_ACTION_TEXT, AllIcons.Actions.Execute){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ShowAffectedTestsAction.runAllDiscoveredTests(project2, tree, (Ref<? extends JBPopup>)ref, context, initTitle);
                    }
                });
            }
            if ((popup = (JBPopup)ref.get()) != null) {
                popup.cancel();
            }
        };
        KeyStroke findUsageKeyStroke = ShowAffectedTestsAction.findUsagesKeyStroke();
        String pinTooltip = "Open Find Usages Toolwindow" + (findUsageKeyStroke == null ? "" : " " + KeymapUtil.getKeystrokeText((KeyStroke)findUsageKeyStroke));
        ActiveComponent pinButton = ShowAffectedTestsAction.createButton(pinTooltip, AllIcons.General.Pin_tab, pinActionListener, tree);
        PopupChooserBuilder builder = new PopupChooserBuilder((JTree)((Object)tree)).setTitle(initTitle).setMovable(true).setResizable(true).setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{pinButton})).setSettingButton((Component)new CompositeActiveComponent(new ActiveComponent[]{runButton}).getComponent()).setItemChoosenCallback(() -> PsiNavigateUtil.navigate((PsiElement)tree.getSelectedElement())).registerKeyboardAction(findUsageKeyStroke, __ -> pinActionListener.run()).setMinSize((Dimension)new JBDimension(500, 300)).setDimensionServiceKey(ShowAffectedTestsAction.class.getSimpleName());
        final JBPopup popup = builder.createPopup();
        ref.set((Object)popup);
        TreeModel model = tree.getModel();
        Disposer.register((Disposable)popup, (Disposable)tree);
        model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                int testsCount = tree.getTestCount();
                int classesCount = tree.getTestClassesCount();
                popup.setCaption("Found " + testsCount + " " + StringUtil.pluralize((String)"Test", (int)testsCount) + " in " + classesCount + " " + StringUtil.pluralize((String)"Class", (int)classesCount) + " for " + title);
            }
        });
        popup.showInBestPositionFor(dataContext);
        return tree;
    }

    public static void processMethodsAsync(@NotNull Project project2, @NotNull PsiMethod[] methods, @NotNull List<String> filePaths, @NotNull TestDiscoveryProducer.PsiTestProcessor processor2, @Nullable Runnable doWhenDone) {
        if (DumbService.isDumb((Project)project2)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ShowAffectedTestsAction.processMethods(project2, methods, filePaths, processor2);
            if (doWhenDone != null) {
                EdtInvocationManager.getInstance().invokeLater(doWhenDone);
            }
        });
    }

    public static void processMethods(@NotNull Project project2, @NotNull PsiMethod[] methods, @NotNull List<String> filePaths, @NotNull TestDiscoveryProducer.PsiTestProcessor processor2) {
        if (DumbService.isDumb((Project)project2)) {
            return;
        }
        List classesAndMethods = (List)ReadAction.compute(() -> Arrays.stream(methods).map(method -> ShowAffectedTestsAction.getMethodKey(method)).filter(Objects::nonNull).collect(Collectors.toList()));
        ShowAffectedTestsAction.processTestDiscovery(project2, processor2, classesAndMethods, filePaths);
    }

    private static void processTestDiscovery(@NotNull Project project2, @NotNull TestDiscoveryProducer.PsiTestProcessor processor2, @NotNull List<Couple<String>> classesAndMethods, @NotNull List<String> filePaths) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project2);
        for (TestDiscoveryConfigurationProducer producer : ShowAffectedTestsAction.getRunConfigurationProducers(project2)) {
            byte frameworkId = ((JavaTestConfigurationWithDiscoverySupport)producer.getConfigurationFactory().createTemplateConfiguration(project2)).getTestFrameworkId();
            TestDiscoveryProducer.consumeDiscoveredTests(project2, classesAndMethods, frameworkId, filePaths, (testClass, testMethod, parameter) -> {
                PsiClass[] testClassPsi = new PsiClass[]{null};
                PsiMethod[] testMethodPsi = new PsiMethod[]{null};
                ReadAction.run(() -> DumbService.getInstance((Project)project2).runWithAlternativeResolveEnabled(() -> {
                    boolean checkBases;
                    testClassPsi[0] = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project2), (String)testClass, null, (boolean)true, (GlobalSearchScope)scope);
                    boolean bl = checkBases = parameter != null;
                    if (testClassPsi[0] != null) {
                        testMethodPsi[0] = (PsiMethod)ArrayUtil.getFirstElement((Object[])testClassPsi[0].findMethodsByName(testMethod, checkBases));
                    }
                }));
                return testClassPsi[0] == null || processor2.process(testClassPsi[0], testMethodPsi[0], parameter);
            });
        }
    }

    @NotNull
    private static ActiveComponent createButton(final @NotNull String text, final @NotNull Icon icon, final @NotNull Runnable listener, final @NotNull DiscoveredTestsTree tree) {
        return new ActiveComponent.Adapter(){

            @NotNull
            public JComponent getComponent() {
                final Presentation presentation = new Presentation();
                presentation.setText(text);
                presentation.setDescription(text);
                presentation.setIcon(icon);
                presentation.setEnabled(false);
                tree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                    protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                        if (!presentation.isEnabled() && tree.getTestCount() != 0) {
                            presentation.setEnabled(true);
                        }
                    }
                });
                return new ActionButton(new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        listener.run();
                    }
                }, presentation, "ShowDiscoveredTestsToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            }
        };
    }

    private static void runAllDiscoveredTests(@NotNull Project project2, @NotNull DiscoveredTestsTree tree, @NotNull Ref<? extends JBPopup> ref, @NotNull ConfigurationContext context, @NotNull String title) {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Module targetModule = TestDiscoveryConfigurationProducer.detectTargetModule(tree.getContainingModules(), project2);
        List testMethods = Arrays.stream(tree.getTestMethods()).map(TestMethodUsage::calculateLocation).filter(Objects::nonNull).collect(Collectors.toList());
        ShowAffectedTestsAction.getRunConfigurationProducers(project2).stream().map(producer -> Pair.pair((Object)producer, (Object)ContainerUtil.filter((Collection)testMethods, producer::isApplicable))).max(Comparator.comparingInt(p -> ((List)p.second).size())).map(p -> {
            Location[] locations = ((List)p.second).toArray(new Location[0]);
            return ((TestDiscoveryConfigurationProducer)((Object)((Object)p.first))).createProfile(locations, targetModule, context, title);
        }).ifPresent(profile2 -> {
            try {
                ExecutionEnvironmentBuilder.create((Project)project2, (Executor)executor, (RunProfile)profile2).buildAndExecute();
            }
            catch (ExecutionException e) {
                ExecutionUtil.handleExecutionError((Project)project2, (String)executor.getToolWindowId(), (String)title, (Throwable)e);
            }
            JBPopup popup = (JBPopup)ref.get();
            if (popup != null) {
                popup.cancel();
            }
        });
    }

    @Nullable
    public static Couple<String> getMethodKey(@NotNull PsiMethod method) {
        PsiClass c = method.isValid() ? method.getContainingClass() : null;
        String fqn = c != null ? DiscoveredTestsTreeModel.getClassName(c) : null;
        return fqn == null ? null : Couple.of((Object)fqn, (Object)ShowAffectedTestsAction.methodSignature(method));
    }

    @NotNull
    private static String methodSignature(@NotNull PsiMethod method) {
        String tail = "/" + ClassUtil.getAsmMethodSignature((PsiMethod)method);
        return (method.isConstructor() ? "<init>" : method.getName()) + tail;
    }

    @Nullable
    private static KeyStroke findUsagesKeyStroke() {
        AnAction action = ActionManager.getInstance().getAction("FindUsages");
        ShortcutSet shortcutSet = action == null ? null : action.getShortcutSet();
        return shortcutSet == null ? null : KeymapUtil.getKeyStroke((ShortcutSet)shortcutSet);
    }

    @NotNull
    private static List<TestDiscoveryConfigurationProducer> getRunConfigurationProducers(@NotNull Project project2) {
        return RunConfigurationProducer.getProducers((Project)project2).stream().filter(producer -> producer instanceof TestDiscoveryConfigurationProducer).map(producer -> (TestDiscoveryConfigurationProducer)((Object)producer)).collect(Collectors.toList());
    }

    @NotNull
    public static List<String> getRelativeAffectedPaths(@NotNull Project project2, @NotNull Collection<? extends Change> changes) {
        VirtualFile baseDir = ShowAffectedTestsAction.getBasePathAsVirtualFile(project2);
        return baseDir == null ? Collections.emptyList() : changes.stream().map(change -> ShowAffectedTestsAction.relativePath(baseDir, change)).filter(Objects::nonNull).map(s -> "/" + s).collect(Collectors.toList());
    }

    @Nullable
    static VirtualFile getBasePathAsVirtualFile(@NotNull Project project2) {
        String basePath = project2.getBasePath();
        return basePath == null ? null : LocalFileSystem.getInstance().findFileByPath(basePath);
    }

    @Nullable
    private static String relativePath(@NotNull VirtualFile baseDir, @NotNull Change change) {
        ContentRevision before;
        VirtualFile file = change.getVirtualFile();
        if (file == null && (before = change.getBeforeRevision()) != null) {
            return VcsFileUtil.relativePath((VirtualFile)baseDir, (FilePath)before.getFile());
        }
        return file == null ? null : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)baseDir);
    }
}

