/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInModule;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TestMethodUsage
implements Usage,
UsageInFile,
UsageInModule,
PsiElementUsage,
DataProvider {
    @NotNull
    private final SmartPsiElementPointer<? extends PsiMethod> myTestMethodPointer;
    @Nullable
    private final SmartPsiElementPointer<? extends PsiClass> myTestClassPointer;

    TestMethodUsage(@NotNull SmartPsiElementPointer<? extends PsiMethod> testMethod, @NotNull SmartPsiElementPointer<? extends PsiClass> testClass, @NotNull Collection<String> parameters) {
        this.myTestMethodPointer = testMethod;
        this.myTestClassPointer = parameters.isEmpty() ? null : testClass;
    }

    @Nullable
    public Location<PsiMethod> calculateLocation() {
        PsiClass c;
        PsiMethod m = (PsiMethod)this.myTestMethodPointer.getElement();
        if (m == null) {
            return null;
        }
        PsiClass psiClass = c = this.myTestClassPointer == null ? m.getContainingClass() : (PsiClass)this.myTestClassPointer.getElement();
        if (c == null) {
            return null;
        }
        return MethodLocation.elementInClass(m, c);
    }

    public VirtualFile getFile() {
        return this.getPointer().getVirtualFile();
    }

    public Module getModule() {
        return ModuleUtilCore.findModuleForFile((PsiFile)this.getPointer().getContainingFile());
    }

    @NotNull
    public UsagePresentation getPresentation() {
        return new UsagePresentation(){

            @NotNull
            public TextChunk[] getText() {
                return new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), this.getPlainText())};
            }

            @NotNull
            public String getPlainText() {
                return StringUtil.notNullize((String)Objects.requireNonNull(TestMethodUsage.this.getElement()).getName());
            }

            public Icon getIcon() {
                return Objects.requireNonNull(TestMethodUsage.this.getElement()).getIcon(0);
            }

            public String getTooltipText() {
                return this.getPlainText();
            }
        };
    }

    public boolean isValid() {
        return this.getPointer().getElement() != null;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    public FileEditorLocation getLocation() {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        Project project2 = this.getPointer().getProject();
        FileEditor editor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(virtualFile);
        if (!(editor instanceof TextEditor)) {
            return null;
        }
        Segment segment = this.getPointer().getPsiRange();
        if (segment == null) {
            return null;
        }
        return new TextEditorLocation(segment.getStartOffset(), (TextEditor)editor);
    }

    public void selectInEditor() {
        this.navigate(true);
    }

    public void highlightInEditor() {
        PsiMember element = this.getElement();
        if (element != null) {
            Project project2 = this.getPointer().getProject();
            TextRange range = element.getTextRange();
            SelectInEditorManager.getInstance((Project)project2).selectInEditor(this.getFile(), range.getStartOffset(), range.getEndOffset(), false, false);
        }
    }

    public void navigate(boolean requestFocus) {
        PsiMember element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @Nullable
    public PsiMember getElement() {
        return (PsiMember)this.getPointer().getElement();
    }

    @NotNull
    private SmartPsiElementPointer<? extends PsiMember> getPointer() {
        return this.myTestClassPointer != null ? this.myTestClassPointer : this.myTestMethodPointer;
    }

    public boolean isNonCodeUsage() {
        return false;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (!UsageView.USAGE_INFO_LIST_KEY.is(dataId)) {
            return null;
        }
        PsiMember psi = this.getElement();
        return psi == null ? null : Collections.singletonList(new UsageInfo((PsiElement)psi));
    }
}

