/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.DiscoveredTestsIndex;
import com.intellij.execution.testDiscovery.indices.PersistentObjectSeq;
import com.intellij.execution.testDiscovery.indices.TestFilesIndex;
import com.intellij.execution.testDiscovery.indices.TestId;
import com.intellij.execution.testDiscovery.indices.TestModuleIndex;
import com.intellij.execution.testDiscovery.indices.UsedSources;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiscoveredTestDataHolder {
    private static final Logger LOG = Logger.getInstance(DiscoveredTestDataHolder.class);
    private final DiscoveredTestsIndex myDiscoveredTestsIndex;
    private final TestFilesIndex myTestFilesIndex;
    private final TestModuleIndex myTestModuleIndex;
    private final PersistentStringEnumerator myClassEnumerator;
    private final PersistentStringEnumerator myMethodEnumerator;
    private final PersistentStringEnumerator myPathEnumerator;
    private final PersistentEnumeratorDelegate<TestId> myTestEnumerator;
    private final PersistentObjectSeq myConstructedDataFiles = new PersistentObjectSeq();
    private boolean myDisposed;
    private final Disposable myDisposable = Disposer.newDisposable();
    static final int VERSION = 10;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DiscoveredTestDataHolder(@NotNull Path basePath) {
        Path versionFile = DiscoveredTestDataHolder.getVersionFile(basePath);
        PathKt.createDirectories((Path)basePath);
        File discoveredTestsIndexFile = basePath.resolve("discoveredTests.index").toFile();
        File testFilesIndexFile = basePath.resolve("testFiles.index").toFile();
        File classNameEnumeratorFile = basePath.resolve("className.enum").toFile();
        File methodNameEnumeratorFile = basePath.resolve("methodName.enum").toFile();
        File pathEnumeratorFile = basePath.resolve("path.enum").toFile();
        File testNameEnumeratorFile = basePath.resolve("testName.enum").toFile();
        try {
            PersistentEnumeratorDelegate testEnumerator;
            PersistentStringEnumerator pathEnumerator;
            PersistentStringEnumerator methodEnumerator;
            PersistentStringEnumerator classNameEnumerator;
            TestModuleIndex testModuleIndex;
            TestFilesIndex testFilesIndex;
            DiscoveredTestsIndex discoveredTestsIndex;
            int version = DiscoveredTestDataHolder.readVersion(versionFile);
            if (version != 10) {
                LOG.info(version != -1 ? "TestDiscoveryIndex was rewritten due to version change" : "TestDiscoveryIndex is not exist. Empty index is created");
                PathKt.delete((Path)basePath);
                DiscoveredTestDataHolder.writeVersion(versionFile);
            }
            int iterations = 0;
            while (true) {
                ++iterations;
                try {
                    discoveredTestsIndex = new DiscoveredTestsIndex(discoveredTestsIndexFile);
                    this.myConstructedDataFiles.add((InvertedIndex<?, ?, ?>)discoveredTestsIndex);
                    testFilesIndex = new TestFilesIndex(testFilesIndexFile);
                    this.myConstructedDataFiles.add((InvertedIndex<?, ?, ?>)testFilesIndex);
                    testModuleIndex = new TestModuleIndex(basePath, this.myConstructedDataFiles);
                    classNameEnumerator = new PersistentStringEnumerator(classNameEnumeratorFile, true);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate<?>)classNameEnumerator);
                    methodEnumerator = new PersistentStringEnumerator(methodNameEnumeratorFile, true);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate<?>)methodEnumerator);
                    pathEnumerator = new PersistentStringEnumerator(pathEnumeratorFile, true);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate<?>)pathEnumerator);
                    testEnumerator = new PersistentEnumeratorDelegate(testNameEnumeratorFile, TestId.DESCRIPTOR, 4096);
                    this.myConstructedDataFiles.add(testEnumerator);
                }
                catch (Throwable throwable) {
                    LOG.info("TestDiscoveryIndex problem", throwable);
                    this.myConstructedDataFiles.close(true);
                    this.myConstructedDataFiles.clear();
                    PathKt.delete((Path)basePath);
                    if (iterations < 3) continue;
                    LOG.error("Unexpected circular initialization problem");
                    assert (false);
                    continue;
                }
                break;
            }
            this.myDiscoveredTestsIndex = discoveredTestsIndex;
            this.myTestFilesIndex = testFilesIndex;
            this.myTestModuleIndex = testModuleIndex;
            this.myClassEnumerator = classNameEnumerator;
            this.myMethodEnumerator = methodEnumerator;
            this.myPathEnumerator = pathEnumerator;
            this.myTestEnumerator = testEnumerator;
            LowMemoryWatcher.register(() -> this.myConstructedDataFiles.flush(), (Disposable)this.myDisposable);
            return;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeVersion(@NotNull Path versionFile) throws IOException {
        try (DataOutputStream versionOut = new DataOutputStream(PathKt.outputStream((Path)versionFile));){
            DataInputOutputUtil.writeINT((DataOutput)versionOut, (int)10);
        }
    }

    private static int readVersion(@NotNull Path versionFile) throws IOException {
        InputStream inputStream = PathKt.inputStreamIfExists((Path)versionFile);
        if (inputStream == null) {
            return -1;
        }
        try (DataInputStream versionInput = new DataInputStream(inputStream);){
            int n = DataInputOutputUtil.readINT((DataInput)versionInput);
            return n;
        }
    }

    public void flush() {
        this.myConstructedDataFiles.flush();
    }

    public void dispose() {
        try {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myConstructedDataFiles.close(false);
        }
        finally {
            this.myDisposed = true;
        }
    }

    public boolean hasTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int testId = this.myTestEnumerator.tryEnumerate((Object)this.createTestId(testClassName, testMethodName, frameworkId));
        return testId != 0 && this.myDiscoveredTestsIndex.containsDataFrom(testId);
    }

    public void removeTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int testId = this.myTestEnumerator.tryEnumerate((Object)this.createTestId(testClassName, testMethodName, frameworkId));
        if (testId != 0) {
            this.myDiscoveredTestsIndex.update(testId, null).compute();
            this.myTestModuleIndex.removeTest(testId);
        }
    }

    @NotNull
    public Collection<String> getTestModulesByMethodName(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int testId = this.myTestEnumerator.tryEnumerate((Object)this.createTestId(testClassName, testMethodName, frameworkId));
        if (testId != 0) {
            return this.myTestModuleIndex.getTestRunModules(testId);
        }
        return Collections.emptySet();
    }

    public void updateTestData(@NotNull String testClassName, @NotNull String testMethodName, @NotNull MultiMap<String, String> usedMethods, @NotNull List<String> usedFiles, @Nullable String moduleName, byte frameworkId) throws IOException {
        int testNameId = this.myTestEnumerator.enumerate((Object)this.createTestId(testClassName, testMethodName, frameworkId));
        HashMap<Integer, TIntArrayList> result = new HashMap<Integer, TIntArrayList>();
        for (Object e : usedMethods.entrySet()) {
            TIntArrayList methodIds = new TIntArrayList(((Collection)e.getValue()).size());
            result.put(this.myClassEnumerator.enumerate((String)e.getKey()), methodIds);
            for (String methodName : (Collection)e.getValue()) {
                methodIds.add(this.myMethodEnumerator.enumerate(methodName));
            }
        }
        HashMap<Integer, Void> usedVirtualFileIds = new HashMap<Integer, Void>();
        for (String file : usedFiles) {
            if (!file.contains("testData") && !file.contains("test-data") && !file.contains("test_data")) continue;
            int fileId = this.myPathEnumerator.enumerate(file);
            usedVirtualFileIds.put(fileId, null);
        }
        UsedSources usedSources = new UsedSources(result, usedVirtualFileIds);
        this.myDiscoveredTestsIndex.update(testNameId, usedSources).compute();
        this.myTestFilesIndex.update(testNameId, usedSources).compute();
        this.myTestModuleIndex.appendModuleData(testNameId, moduleName);
    }

    @NotNull
    public MultiMap<String, String> getTestsByFile(@NotNull String relativePath, byte frameworkId) throws IOException {
        int fileId = this.myPathEnumerator.tryEnumerate((Object)relativePath);
        if (fileId == 0) {
            return MultiMap.empty();
        }
        try {
            MultiMap result = new MultiMap();
            IOException[] exception = new IOException[]{null};
            this.myTestFilesIndex.getData(fileId).forEach((testId, v) -> this.consumeDiscoveredTest(testId, frameworkId, (MultiMap<String, String>)result, exception));
            if (exception[0] != null) {
                throw exception[0];
            }
            return result;
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public MultiMap<String, String> getTestsByClassName(@NotNull String classFQName, byte frameworkId) throws IOException {
        int classId = this.myClassEnumerator.tryEnumerate((Object)classFQName);
        if (classId == 0) {
            return MultiMap.empty();
        }
        try {
            MultiMap result = new MultiMap();
            IOException[] exception = new IOException[]{null};
            this.myDiscoveredTestsIndex.getData(classId).forEach((testId, value) -> this.consumeDiscoveredTest(testId, frameworkId, (MultiMap<String, String>)result, exception));
            if (exception[0] != null) {
                throw exception[0];
            }
            return result;
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public MultiMap<String, String> getTestsByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) throws IOException {
        int methodId = this.myMethodEnumerator.tryEnumerate((Object)methodName);
        if (methodId == 0) {
            return MultiMap.empty();
        }
        int classId = this.myClassEnumerator.tryEnumerate((Object)classFQName);
        if (classId == 0) {
            return MultiMap.empty();
        }
        try {
            MultiMap result = new MultiMap();
            IOException[] exception = new IOException[]{null};
            this.myDiscoveredTestsIndex.getData(classId).forEach((testId, value) -> !value.contains(methodId) || this.consumeDiscoveredTest(testId, frameworkId, (MultiMap<String, String>)result, exception));
            if (exception[0] != null) {
                throw exception[0];
            }
            return result;
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public Collection<String> getAffectedFiles(@NotNull Couple<String> testQName, byte frameworkId) throws IOException {
        int testId = this.myTestEnumerator.tryEnumerate((Object)this.createTestId((String)testQName.getFirst(), (String)testQName.getSecond(), frameworkId));
        if (testId == 0) {
            return Collections.emptySet();
        }
        Collection<Integer> affectedFiles2 = this.myTestFilesIndex.getTestDataFor(testId);
        if (affectedFiles2 == null) {
            return Collections.emptySet();
        }
        ArrayList<String> result = new ArrayList<String>(affectedFiles2.size());
        for (Integer fileId : affectedFiles2) {
            String filePath2 = this.myPathEnumerator.valueOf(fileId.intValue());
            if (filePath2 != null) {
                result.add(filePath2);
                continue;
            }
            LOG.error("file path is empty for file id =" + fileId);
        }
        return result;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    static Path getVersionFile(Path path) {
        return path.resolve("index.version");
    }

    @NotNull
    private TestId createTestId(String className, String methodName, byte frameworkPrefix) throws IOException {
        return new TestId(this.myClassEnumerator.enumerate(className), this.myMethodEnumerator.enumerate(methodName), frameworkPrefix);
    }

    private boolean consumeDiscoveredTest(int testId, byte frameworkId, @NotNull MultiMap<String, String> result, @NotNull IOException[] exceptionRef) {
        try {
            TestId test = (TestId)this.myTestEnumerator.valueOf(testId);
            if (test.getFrameworkId() == frameworkId) {
                String testClassName = this.myClassEnumerator.valueOf(test.getClassId());
                String testMethodName = this.myMethodEnumerator.valueOf(test.getMethodId());
                result.putValue((Object)testClassName, (Object)testMethodName);
            }
        }
        catch (IOException e) {
            exceptionRef[0] = e;
            return false;
        }
        return true;
    }
}

