/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.IntArrayExternalizer;
import com.intellij.execution.testDiscovery.indices.UsedSources;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DiscoveredTestsIndex
extends MapReduceIndex<Integer, TIntArrayList, UsedSources> {
    private static final IndexExtension<Integer, TIntArrayList, UsedSources> INDEX_EXTENSION = new IndexExtension<Integer, TIntArrayList, UsedSources>(){

        @NotNull
        public IndexId<Integer, TIntArrayList> getName() {
            return IndexId.create((String)"jvm.discovered.tests");
        }

        @NotNull
        public DataIndexer<Integer, TIntArrayList, UsedSources> getIndexer() {
            return inputData -> inputData.myUsedMethods;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            return EnumeratorIntegerDescriptor.INSTANCE;
        }

        @NotNull
        public DataExternalizer<TIntArrayList> getValueExternalizer() {
            return IntArrayExternalizer.INSTANCE;
        }

        public int getVersion() {
            return 10;
        }
    };

    protected DiscoveredTestsIndex(final @NotNull File file) throws IOException {
        super(INDEX_EXTENSION, (IndexStorage)new MyIndexStorage(file), (ForwardIndex)new MyForwardIndex(){

            @NotNull
            public PersistentHashMap<Integer, Collection<Integer>> createMap() throws IOException {
                return new PersistentHashMap(new File(file, "forward.idx"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntCollectionDataExternalizer());
            }
        });
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable e) {
    }

    public boolean containsDataFrom(int testId) throws IOException {
        return ((MyForwardIndex)this.myForwardIndex).containsDataFrom(testId);
    }

    private static abstract class MyForwardIndex
    extends KeyCollectionBasedForwardIndex<Integer, TIntArrayList> {
        protected MyForwardIndex() throws IOException {
            super(INDEX_EXTENSION);
        }

        public boolean containsDataFrom(int testId) throws IOException {
            return this.getInput(testId) != null;
        }
    }

    private static class MyIndexStorage
    extends MapIndexStorage<Integer, TIntArrayList> {
        protected MyIndexStorage(@NotNull File storageFile) throws IOException {
            super(storageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)IntArrayExternalizer.INSTANCE, 4096, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }
    }
}

