/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class IntArrayExternalizer
implements DataExternalizer<TIntArrayList> {
    static final IntArrayExternalizer INSTANCE = new IntArrayExternalizer();

    IntArrayExternalizer() {
    }

    public void save(@NotNull DataOutput out, TIntArrayList value) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
        for (int i = 0; i < value.size(); ++i) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(i));
        }
    }

    public TIntArrayList read(@NotNull DataInput in) throws IOException {
        int size = DataInputOutputUtil.readINT((DataInput)in);
        TIntArrayList array = new TIntArrayList(size);
        for (int i = 0; i < size; ++i) {
            array.add(DataInputOutputUtil.readINT((DataInput)in));
        }
        return array;
    }
}

