/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.UsedSources;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFilesIndex
extends MapReduceIndex<Integer, Void, UsedSources> {
    private static final IndexExtension<Integer, Void, UsedSources> INDEX_EXTENSION = new IndexExtension<Integer, Void, UsedSources>(){

        @NotNull
        public IndexId<Integer, Void> getName() {
            return IndexId.create((String)"jvm.discovered.test.files");
        }

        @NotNull
        public DataIndexer<Integer, Void, UsedSources> getIndexer() {
            return inputData -> inputData.myUsedFiles;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            return EnumeratorIntegerDescriptor.INSTANCE;
        }

        @NotNull
        public DataExternalizer<Void> getValueExternalizer() {
            return VoidDataExternalizer.INSTANCE;
        }

        public int getVersion() {
            return 10;
        }
    };

    protected TestFilesIndex(final @NotNull File file) throws IOException {
        super(INDEX_EXTENSION, (IndexStorage)new MyIndexStorage(file), (ForwardIndex)new MyForwardIndex(){

            @NotNull
            public PersistentHashMap<Integer, Collection<Integer>> createMap() throws IOException {
                return new PersistentHashMap(new File(file, "forward.idx"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntCollectionDataExternalizer());
            }
        });
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable e) {
    }

    @Nullable
    Collection<Integer> getTestDataFor(int testId) throws IOException {
        return ((MyForwardIndex)this.myForwardIndex).containsDataFrom(testId);
    }

    private static abstract class MyForwardIndex
    extends KeyCollectionBasedForwardIndex<Integer, Void> {
        protected MyForwardIndex() throws IOException {
            super(INDEX_EXTENSION);
        }

        @Nullable
        public Collection<Integer> containsDataFrom(int testId) throws IOException {
            return (Collection)this.getInput(testId);
        }
    }

    private static class MyIndexStorage
    extends MapIndexStorage<Integer, Void> {
        protected MyIndexStorage(@NotNull File storageFile) throws IOException {
            super(storageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)VoidDataExternalizer.INSTANCE, 4096, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }
    }
}

