/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TestId {
    private final int myClassId;
    private final int myMethodId;
    private final byte myFrameworkId;
    static final KeyDescriptor<TestId> DESCRIPTOR = new KeyDescriptor<TestId>(){

        public int getHashCode(TestId id) {
            return id.hashCode();
        }

        public boolean isEqual(TestId id1, TestId id2) {
            return id1.equals(id2);
        }

        public void save(@NotNull DataOutput out, TestId id) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)id.getClassId());
            DataInputOutputUtil.writeINT((DataOutput)out, (int)id.getMethodId());
            out.writeByte(id.getFrameworkId());
        }

        public TestId read(@NotNull DataInput in) throws IOException {
            return new TestId(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), in.readByte());
        }
    };

    TestId(int classId, int methodId, byte id) {
        this.myClassId = classId;
        this.myMethodId = methodId;
        this.myFrameworkId = id;
    }

    public int getClassId() {
        return this.myClassId;
    }

    public int getMethodId() {
        return this.myMethodId;
    }

    public byte getFrameworkId() {
        return this.myFrameworkId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestId id = (TestId)o;
        return this.myClassId == id.myClassId && this.myMethodId == id.myMethodId && this.myFrameworkId == id.myFrameworkId;
    }

    public int hashCode() {
        return Objects.hash(this.myClassId, this.myMethodId, this.myFrameworkId);
    }
}

