/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;

public abstract class AbstractJavaTestConfigurationProducer<T extends JavaTestConfigurationBase>
extends JavaRunConfigurationProducerBase<T> {
    @Deprecated
    protected AbstractJavaTestConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected AbstractJavaTestConfigurationProducer() {
    }

    @Contract(value="null->false")
    protected boolean isTestClass(PsiClass psiClass) {
        if (psiClass != null) {
            JavaTestFramework framework = this.getCurrentFramework(psiClass);
            return framework != null && framework.isTestClass((PsiElement)psiClass);
        }
        return false;
    }

    protected boolean isTestMethod(boolean checkAbstract, PsiMethod method) {
        JavaTestFramework framework = this.getCurrentFramework(method.getContainingClass());
        return framework != null && framework.isTestMethod((PsiElement)method, checkAbstract);
    }

    protected JavaTestFramework getCurrentFramework(PsiClass psiClass) {
        if (psiClass != null) {
            ConfigurationType configurationType = this.getConfigurationType();
            Set frameworks = TestFrameworks.detectApplicableFrameworks((PsiClass)psiClass);
            return frameworks.stream().filter(framework -> framework instanceof JavaTestFramework && ((JavaTestFramework)framework).isMyConfigurationType(configurationType)).map(framework -> (JavaTestFramework)framework).findFirst().orElse(null);
        }
        return null;
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return true;
    }

    public boolean isConfigurationFromContext(T configuration, ConfigurationContext context) {
        if (this.isMultipleElementsSelected(context)) {
            return false;
        }
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration(this.getConfigurationType());
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return false;
        }
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        RunnerAndConfigurationSettings template = context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
        JavaTestConfigurationBase templateConfiguration = (JavaTestConfigurationBase)template.getConfiguration();
        Module predefinedModule = ((JavaRunConfigurationModule)templateConfiguration.getConfigurationModule()).getModule();
        String vmParameters = predefinedConfiguration != null ? (predefinedConfiguration instanceof CommonJavaRunConfigurationParameters ? ((CommonJavaRunConfigurationParameters)predefinedConfiguration).getVMParameters() : null) : templateConfiguration.getVMParameters();
        if (!Comparing.strEqual((String)vmParameters, (String)configuration.getVMParameters())) {
            return false;
        }
        if (this.differentParamSet(configuration, contextLocation)) {
            return false;
        }
        if (!this.isApplicableTestType(((JavaTestConfigurationBase)configuration).getTestType(), context)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass != null && this.getCurrentFramework(psiClass) == null) {
            return false;
        }
        if (((JavaTestConfigurationBase)configuration).isConfiguredByElement(element)) {
            Module configurationModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
            Module locationModule = location.getModule();
            if (Comparing.equal((Object)locationModule, (Object)configurationModule)) {
                return true;
            }
            if ((predefinedModule != null || locationModule == null) && Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }

    protected boolean differentParamSet(T configuration, Location contextLocation) {
        String paramSetName = contextLocation instanceof PsiMemberParameterizedLocation ? ((JavaTestConfigurationBase)configuration).prepareParameterizedParameter(((PsiMemberParameterizedLocation)contextLocation).getParamSetName()) : null;
        return !Comparing.strEqual((String)paramSetName, (String)configuration.getProgramParameters());
    }

    public Module findModule(ModuleBasedConfiguration configuration, Module contextModule, Set<String> patterns) {
        return JavaExecutionUtil.findModule((Module)contextModule, patterns, (Project)configuration.getProject(), psiClass -> this.isTestClass((PsiClass)psiClass));
    }

    public void collectTestMembers(PsiElement[] psiElements, boolean checkAbstract, boolean checkIsTest, PsiElementProcessor.CollectElements<PsiElement> collectingProcessor) {
        for (PsiElement psiElement : psiElements) {
            PsiClass containingClass;
            if (psiElement instanceof PsiDirectory) {
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement);
                if (aPackage == null || collectingProcessor.execute((PsiElement)aPackage)) continue;
                return;
            }
            if ((psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class, (boolean)false)) instanceof PsiClassOwner) {
                PsiClass[] classes;
                for (PsiClass aClass : classes = ((PsiClassOwner)psiElement).getClasses()) {
                    if ((checkIsTest || !this.isRequiredVisibility((PsiMember)aClass)) && (!checkIsTest || !this.isTestClass(aClass)) || collectingProcessor.execute((PsiElement)aClass)) continue;
                    return;
                }
                continue;
            }
            if (psiElement instanceof PsiClass) {
                if ((checkIsTest || !this.isRequiredVisibility((PsiMember)((PsiClass)psiElement))) && (!checkIsTest || !this.isTestClass((PsiClass)psiElement)) || collectingProcessor.execute(psiElement)) continue;
                return;
            }
            if (!(psiElement instanceof PsiMethod)) continue;
            if (checkIsTest && this.isTestMethod(checkAbstract, (PsiMethod)psiElement) && !collectingProcessor.execute(psiElement)) {
                return;
            }
            if (checkIsTest || (containingClass = ((PsiMethod)psiElement).getContainingClass()) == null || !this.isRequiredVisibility((PsiMember)containingClass) || collectingProcessor.execute(psiElement)) continue;
            return;
        }
    }

    protected boolean isRequiredVisibility(PsiMember psiElement) {
        return psiElement.hasModifierProperty("public");
    }

    protected boolean collectContextElements(DataContext dataContext, boolean checkAbstract, boolean checkIsTest, LinkedHashSet<String> classes, PsiElementProcessor.CollectElements<PsiElement> processor2) {
        Project project2;
        VirtualFile[] files;
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            return this.collectTestMembers(elements, checkAbstract, checkIsTest, processor2, classes);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = null;
        if (editor != null) {
            PsiFile editorFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            List allCarets = editor.getCaretModel().getAllCarets();
            if (editorFile != null) {
                if (allCarets.size() > 1) {
                    LinkedHashSet methods = new LinkedHashSet();
                    for (Caret caret : allCarets) {
                        ContainerUtil.addIfNotNull(methods, (Object)PsiTreeUtil.getParentOfType((PsiElement)editorFile.findElementAt(caret.getOffset()), PsiMethod.class));
                    }
                    if (!methods.isEmpty()) {
                        return this.collectTestMembers(methods.toArray(PsiElement.EMPTY_ARRAY), checkAbstract, checkIsTest, processor2, classes);
                    }
                } else {
                    int selectionStart;
                    PsiClass psiClass;
                    element = editorFile.findElementAt(editor.getCaretModel().getOffset());
                    SelectionModel selectionModel = editor.getSelectionModel();
                    if (selectionModel.hasSelection() && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)editorFile.findElementAt(selectionStart = selectionModel.getSelectionStart()), PsiClass.class)) != null) {
                        TextRange selectionRange = new TextRange(selectionStart, selectionModel.getSelectionEnd());
                        PsiMethod[] methodsInSelection = (PsiMethod[])Arrays.stream(psiClass.getMethods()).filter(method -> {
                            TextRange methodTextRange = method.getTextRange();
                            return methodTextRange != null && selectionRange.contains(methodTextRange);
                        }).toArray(PsiMethod[]::new);
                        if (methodsInSelection.length > 0) {
                            return this.collectTestMembers((PsiElement[])methodsInSelection, checkAbstract, checkIsTest, processor2, classes);
                        }
                    }
                }
            }
        }
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if ((files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && (project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            for (VirtualFile file : files) {
                PsiFile psiFile = psiManager.findFile(file);
                if (!(psiFile instanceof PsiClassOwner)) continue;
                PsiClass[] psiClasses = ((PsiClassOwner)psiFile).getClasses();
                if (element != null && psiClasses.length > 0) {
                    for (PsiClass aClass : psiClasses) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)element, (boolean)false)) continue;
                        psiClasses = new PsiClass[]{aClass};
                        break;
                    }
                }
                this.collectTestMembers((PsiElement[])psiClasses, checkAbstract, checkIsTest, processor2);
                for (PsiElement psiMember : processor2.getCollection()) {
                    classes.add(((PsiClass)psiMember).getQualifiedName());
                }
            }
            return true;
        }
        return false;
    }

    private boolean collectTestMembers(PsiElement[] elements, boolean checkAbstract, boolean checkIsTest, PsiElementProcessor.CollectElements<PsiElement> processor2, LinkedHashSet<String> classes) {
        this.collectTestMembers(elements, checkAbstract, checkIsTest, processor2);
        for (PsiElement psiClass : processor2.getCollection()) {
            classes.add(this.getQName(psiClass));
        }
        return classes.size() > 1;
    }

    protected PsiElement[] collectLocationElements(LinkedHashSet<String> classes, DataContext dataContext) {
        Location[] locations = (Location[])Location.DATA_KEYS.getData(dataContext);
        if (locations != null) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            for (Location location : locations) {
                String qName;
                PsiElement psiElement = location.getPsiElement();
                if (!(psiElement instanceof PsiNamedElement) || (qName = this.getQName(psiElement, location)) == null) continue;
                classes.add(qName);
                elements.add(psiElement);
            }
            return elements.toArray(PsiElement.EMPTY_ARRAY);
        }
        return null;
    }

    public String getQName(PsiElement psiMember) {
        return this.getQName(psiMember, null);
    }

    public String getQName(PsiElement psiMember, Location location) {
        if (psiMember instanceof PsiClass) {
            return ClassUtil.getJVMClassName((PsiClass)((PsiClass)psiMember));
        }
        if (psiMember instanceof PsiMember) {
            PsiClass containingClass;
            PsiClass psiClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : (containingClass = location instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)location).getContainingClass() : ((PsiMember)psiMember).getContainingClass());
            assert (containingClass != null);
            return ClassUtil.getJVMClassName((PsiClass)containingClass) + "," + this.getMethodPresentation((PsiMember)psiMember);
        }
        if (psiMember instanceof PsiPackage) {
            return ((PsiPackage)psiMember).getQualifiedName() + ".*";
        }
        return null;
    }

    protected String getMethodPresentation(PsiMember psiMember) {
        return psiMember.getName();
    }

    public boolean isMultipleElementsSelected(ConfigurationContext context) {
        if (!context.containsMultipleSelection()) {
            return false;
        }
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return false;
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(2);
        PsiElement[] locationElements = this.collectLocationElements(classes, dataContext);
        if (locationElements != null) {
            this.collectTestMembers(locationElements, false, false, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
        } else {
            this.collectContextElements(dataContext, false, false, classes, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
        }
        return processor2.getCollection().size() > 1;
    }

    public void setupConfigurationParamName(T configuration, Location contextLocation) {
        String paramSetName;
        if (contextLocation instanceof PsiMemberParameterizedLocation && (paramSetName = ((PsiMemberParameterizedLocation)contextLocation).getParamSetName()) != null) {
            configuration.setProgramParameters(((JavaTestConfigurationBase)configuration).prepareParameterizedParameter(paramSetName));
        }
    }
}

