/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.util.HashSet;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;

public class ResetConfigurationModuleAdapter
extends HyperlinkAdapter {
    private static final Logger LOG = Logger.getInstance((String)("#" + ResetConfigurationModuleAdapter.class));
    private final Project myProject;
    private final boolean myIsDebug;
    private final ToolWindowManager myToolWindowManager;
    private final String myTestRunDebugId;
    private final ModuleBasedConfiguration myConfiguration;

    public ResetConfigurationModuleAdapter(ModuleBasedConfiguration configuration, Project project2, boolean isDebug, ToolWindowManager toolWindowManager, String testRunDebugId) {
        this.myProject = project2;
        this.myIsDebug = isDebug;
        this.myToolWindowManager = toolWindowManager;
        this.myTestRunDebugId = testRunDebugId;
        this.myConfiguration = configuration;
    }

    public static <T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>> boolean tryWithAnotherModule(T configuration, boolean isDebug) {
        PsiDirectory[] directories;
        String packageName = ((CommonJavaRunConfigurationParameters)configuration).getPackage();
        if (packageName == null) {
            return false;
        }
        Project project2 = configuration.getProject();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project2).findPackage(packageName);
        if (aPackage == null) {
            return false;
        }
        Module module2 = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (module2 == null) {
            return false;
        }
        HashSet<Module> modulesWithPackage = new HashSet<Module>();
        for (PsiDirectory directory : directories = (PsiDirectory[])ReadAction.compute(() -> aPackage.getDirectories())) {
            Module currentModule = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project2);
            if (module2 == currentModule || currentModule == null) continue;
            modulesWithPackage.add(currentModule);
        }
        if (!modulesWithPackage.isEmpty()) {
            String testRunDebugId = isDebug ? ToolWindowId.DEBUG : ToolWindowId.RUN;
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
            Function moduleNameRef = module1 -> {
                String moduleName = module1.getName();
                return "<a href=\"" + moduleName + "\">" + moduleName + "</a>";
            };
            StringBuilder message = new StringBuilder("Tests were not found in module \"").append(module2.getName()).append("\".\nUse ");
            if (modulesWithPackage.size() == 1) {
                message.append("module \"").append((String)moduleNameRef.fun(modulesWithPackage.iterator().next())).append("\" ");
            } else {
                message.append("one of\n").append(StringUtil.join(modulesWithPackage, (Function)moduleNameRef, (String)"\n")).append("\n");
            }
            message.append("instead");
            UIUtil.invokeLaterIfNeeded(() -> toolWindowManager.notifyByBalloon(testRunDebugId, MessageType.WARNING, message.toString(), null, (HyperlinkListener)((Object)new ResetConfigurationModuleAdapter(configuration, project2, isDebug, toolWindowManager, testRunDebugId))));
            return true;
        }
        return false;
    }

    protected void hyperlinkActivated(HyperlinkEvent e) {
        Module moduleByName = ModuleManager.getInstance((Project)this.myProject).findModuleByName(e.getDescription());
        if (moduleByName != null) {
            this.myConfiguration.getConfigurationModule().setModule(moduleByName);
            try {
                Executor executor = this.myIsDebug ? DefaultDebugExecutor.getDebugExecutorInstance() : DefaultRunExecutor.getRunExecutorInstance();
                ExecutionEnvironmentBuilder.create((Project)this.myProject, (Executor)executor, (RunProfile)this.myConfiguration).contentToReuse(null).buildAndExecute();
                Balloon balloon = this.myToolWindowManager.getToolWindowBalloon(this.myTestRunDebugId);
                if (balloon != null) {
                    balloon.hide();
                }
            }
            catch (ExecutionException e1) {
                LOG.error((Throwable)e1);
            }
        }
    }
}

