/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.testIntegration.TestFailedLineManager;
import com.intellij.util.ui.UIUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TestFailedLineInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                TestStateStorage.Record state = TestFailedLineManager.getInstance((Project)call.getProject()).getFailedLineState(call);
                if (state == null) {
                    return;
                }
                LocalQuickFix[] fixes = new LocalQuickFix[]{new DebugFailedTestFix((PsiElement)call, state.topStacktraceLine), new RunActionFix((PsiElement)call, DefaultRunExecutor.EXECUTOR_ID)};
                ProblemDescriptor descriptor2 = InspectionManager.getInstance((Project)call.getProject()).createProblemDescriptor(nameElement, state.errorMessage, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                descriptor2.setTextAttributes(CodeInsightColors.RUNTIME_ERROR);
                holder.registerProblem(descriptor2);
            }
        };
    }

    private static class RunActionFix
    implements LocalQuickFix,
    Iconable {
        private final ConfigurationContext myContext;
        private final Executor myExecutor;
        private final RunnerAndConfigurationSettings myConfiguration;

        RunActionFix(PsiElement element, String executorId) {
            this.myExecutor = ExecutorRegistry.getInstance().getExecutorById(executorId);
            this.myContext = new ConfigurationContext(element);
            this.myConfiguration = this.myContext.getConfiguration();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String text = this.myExecutor.getStartActionText(ProgramRunnerUtil.shortenName((String)this.myConfiguration.getName(), (int)0));
            return UIUtil.removeMnemonic((String)text);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)this.myConfiguration, (Executor)this.myExecutor);
        }

        public Icon getIcon(int flags) {
            return this.myExecutor.getIcon();
        }
    }

    private static class DebugFailedTestFix
    extends RunActionFix {
        private final String myTopStacktraceLine;

        DebugFailedTestFix(PsiElement element, String topStacktraceLine) {
            super(element, DefaultDebugExecutor.EXECUTOR_ID);
            this.myTopStacktraceLine = topStacktraceLine;
        }

        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Document document2;
            StackTraceLine line = new StackTraceLine(project2, this.myTopStacktraceLine);
            Location<PsiMethod> location = line.getMethodLocation(project2);
            if (location != null && (document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(((PsiMethod)location.getPsiElement()).getContainingFile())) != null) {
                DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager().addLineBreakpoint(document2, line.getLineNumber());
            }
            super.applyFix(project2, descriptor2);
        }
    }
}

