/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassBrowser<T extends JComponent>
extends BrowseModuleValueActionListener<T> {
    private final String myTitle;

    public ClassBrowser(@NotNull Project project2, String title) {
        super(project2);
        this.myTitle = title;
    }

    @Nullable
    protected String showDialog() {
        ClassFilter.ClassFilterWithScope classFilter;
        try {
            classFilter = this.getFilter();
        }
        catch (NoFilterException e) {
            e.getMessageInfo().showNow();
            return null;
        }
        TreeClassChooser dialog = this.createClassChooser(classFilter);
        this.configureDialog(dialog);
        dialog.showDialog();
        PsiClass psiClass = dialog.getSelected();
        if (psiClass == null) {
            return null;
        }
        this.onClassChosen(psiClass);
        return psiClass.getQualifiedName();
    }

    protected abstract ClassFilter.ClassFilterWithScope getFilter() throws NoFilterException;

    protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilter) {
        TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.getProject());
        return factory.createWithInnerClassesScopeChooser(this.myTitle, classFilter.getScope(), (ClassFilter)classFilter, null);
    }

    protected void onClassChosen(@NotNull PsiClass psiClass) {
        this.onClassChoosen(psiClass);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021")
    protected void onClassChoosen(PsiClass psiClass) {
    }

    private void configureDialog(TreeClassChooser dialog) {
        PsiClass psiClass = this.findClass(this.getText());
        if (psiClass == null) {
            return;
        }
        PsiDirectory directory = psiClass.getContainingFile().getContainingDirectory();
        if (directory != null) {
            dialog.selectDirectory(directory);
        }
        dialog.select(psiClass);
    }

    protected abstract PsiClass findClass(String var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021")
    public static ClassBrowser createApplicationClassBrowser(@NotNull Project project2, @NotNull ConfigurationModuleSelector moduleSelector) {
        return new AppClassBrowser(project2, moduleSelector);
    }

    public static class NoFilterException
    extends Exception {
        private final MessagesEx.MessageInfo myMessageInfo;

        public NoFilterException(@NotNull MessagesEx.MessageInfo messageInfo) {
            super(messageInfo.getMessage());
            this.myMessageInfo = messageInfo;
        }

        public MessagesEx.MessageInfo getMessageInfo() {
            return this.myMessageInfo;
        }
    }

    public static class AppClassBrowser<T extends JComponent>
    extends MainClassBrowser<T> {
        private static final ClassFilter CLASS_FILTER = aClass -> PsiMethodUtil.MAIN_CLASS.value((Object)aClass) && ReadAction.compute(() -> PsiMethodUtil.findMainMethod((PsiClass)aClass)) != null;

        public AppClassBrowser(@NotNull Project project2, @NotNull ConfigurationModuleSelector moduleSelector) {
            super(project2, moduleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0]));
        }

        @Override
        protected ClassFilter createFilter(Module module2) {
            return CLASS_FILTER;
        }
    }

    public static abstract class MainClassBrowser<T extends JComponent>
    extends ClassBrowser<T> {
        private final ConfigurationModuleSelector myModuleSelector;

        public MainClassBrowser(@NotNull Project project2, @NotNull ConfigurationModuleSelector moduleSelector, String title) {
            super(project2, title);
            this.myModuleSelector = moduleSelector;
        }

        @Override
        protected PsiClass findClass(String className) {
            return this.myModuleSelector.findClass(className);
        }

        @Override
        protected ClassFilter.ClassFilterWithScope getFilter() {
            Module module2 = this.myModuleSelector.getModule();
            final GlobalSearchScope scope = module2 != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2) : GlobalSearchScope.allScope((Project)this.getProject());
            final ClassFilter filter = this.createFilter(module2);
            return new ClassFilter.ClassFilterWithScope(){

                public GlobalSearchScope getScope() {
                    return scope;
                }

                public boolean isAccepted(PsiClass aClass) {
                    return filter == null || filter.isAccepted(aClass);
                }
            };
        }

        @Nullable
        protected ClassFilter createFilter(@Nullable Module module2) {
            return null;
        }
    }
}

