/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetEditorContextBase
extends UserDataHolderBase
implements FacetEditorContext {
    private final FacetsProvider myFacetsProvider;
    @Nullable
    private final FacetEditorContext myParentContext;
    private final ModulesProvider myModulesProvider;
    private final Facet myFacet;
    private final UserDataHolder mySharedModuleData;
    private final UserDataHolder mySharedProjectData;

    public FacetEditorContextBase(@NotNull Facet facet, @Nullable FacetEditorContext parentContext, @Nullable FacetsProvider facetsProvider, @NotNull ModulesProvider modulesProvider, UserDataHolder sharedModuleData, UserDataHolder sharedProjectData) {
        this.myFacet = facet;
        this.mySharedProjectData = sharedProjectData;
        this.mySharedModuleData = sharedModuleData;
        this.myParentContext = parentContext;
        this.myModulesProvider = modulesProvider;
        this.myFacetsProvider = facetsProvider != null ? facetsProvider : DefaultFacetsProvider.INSTANCE;
    }

    public Library[] getLibraries() {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.getProject()).getLibraries();
    }

    @NotNull
    public String getFacetName() {
        return this.myFacet.getName();
    }

    public VirtualFile[] getLibraryFiles(Library library, OrderRootType rootType) {
        return library.getFiles(rootType);
    }

    @Nullable
    public Library findLibrary(@NotNull String name2) {
        for (Library library : this.getLibraries()) {
            if (!name2.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public UserDataHolder getSharedProjectData() {
        return this.mySharedProjectData;
    }

    public UserDataHolder getSharedModuleData() {
        return this.mySharedModuleData;
    }

    @NotNull
    public abstract ArtifactsStructureConfigurableContext getArtifactsStructureContext();

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Object t = super.getUserData(key);
        if (t == null && this.myParentContext != null) {
            t = this.myParentContext.getUserData(key);
        }
        return (T)t;
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        return this.myFacetsProvider;
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        return this.myModulesProvider;
    }

    @NotNull
    public ModuleRootModel getRootModel() {
        return this.getModifiableRootModel();
    }

    public abstract LibrariesContainer getContainer();

    @NotNull
    public Facet getFacet() {
        return this.myFacet;
    }

    @Nullable
    public Facet getParentFacet() {
        return this.myFacet.getUnderlyingFacet();
    }
}

