/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.google.common.io.BaseEncoding;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequiredLibrariesInfo {
    private final List<LibraryInfo> myLibraryInfos = new ArrayList<LibraryInfo>();

    public RequiredLibrariesInfo(LibraryInfo ... libs) {
        this.myLibraryInfos.addAll(new ArrayList<LibraryInfo>(Arrays.asList(libs)));
    }

    @Nullable
    public RequiredClassesNotFoundInfo checkLibraries(VirtualFile[] libraryFiles) {
        return this.checkLibraries(Arrays.asList(libraryFiles));
    }

    @Nullable
    public RequiredClassesNotFoundInfo checkLibraries(List<VirtualFile> libraryFiles) {
        ArrayList<LibraryInfo> infos = new ArrayList<LibraryInfo>();
        ArrayList<String> classes = new ArrayList<String>();
        for (LibraryInfo info : this.myLibraryInfos) {
            boolean notFound;
            String md5 = info.getMd5();
            if (!StringUtil.isEmptyOrSpaces((String)md5)) {
                notFound = true;
                for (VirtualFile libraryFile : libraryFiles) {
                    VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(libraryFile);
                    if (!md5.equals(RequiredLibrariesInfo.md5(jarFile))) continue;
                    notFound = false;
                    break;
                }
            } else {
                notFound = false;
                for (String className : info.getRequiredClasses()) {
                    if (LibraryUtil.isClassAvailableInLibrary(libraryFiles, (String)className)) continue;
                    classes.add(className);
                    notFound = true;
                }
            }
            if (!notFound) continue;
            infos.add(info);
        }
        if (infos.isEmpty()) {
            return null;
        }
        return new RequiredClassesNotFoundInfo(ArrayUtil.toStringArray(classes), infos.toArray(LibraryInfo.EMPTY_ARRAY));
    }

    @Nullable
    public static String md5(@NotNull VirtualFile file) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(file.contentsToByteArray());
            byte[] digest = md5.digest();
            return BaseEncoding.base16().lowerCase().encode(digest);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getLibrariesPresentableText(LibraryInfo[] libraryInfos) {
        StringBuilder missedJarsText = new StringBuilder();
        for (int i = 0; i < libraryInfos.length; ++i) {
            if (i > 0) {
                missedJarsText.append(", ");
            }
            missedJarsText.append(libraryInfos[i].getName());
        }
        return missedJarsText.toString();
    }

    public static class RequiredClassesNotFoundInfo {
        private final String[] myClassNames;
        private final LibraryInfo[] myLibraryInfos;

        public RequiredClassesNotFoundInfo(String[] classNames, LibraryInfo[] libraryInfos) {
            this.myClassNames = classNames;
            this.myLibraryInfos = libraryInfos;
        }

        public String[] getClassNames() {
            return this.myClassNames;
        }

        public LibraryInfo[] getLibraryInfos() {
            return this.myLibraryInfos;
        }

        public String getMissingJarsText() {
            return RequiredLibrariesInfo.getLibrariesPresentableText(this.myLibraryInfos);
        }
    }
}

