/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.NewProjectAction;
import com.intellij.ide.actions.NewProjectOrModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleAction
extends AnAction
implements NewProjectOrModuleAction {
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";

    public void actionPerformed(@NotNull AnActionEvent e) {
        ImportModuleAction.doImport(ImportModuleAction.getEventProject((AnActionEvent)e));
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(ImportModuleAction.getEventProject((AnActionEvent)e) != null);
        NewProjectAction.updateActionText(this, e);
    }

    @Override
    @NotNull
    public String getActionText(boolean isInNewSubmenu, boolean isInJavaIde) {
        return ProjectBundle.message((String)"import.module.action.text", (Object[])new Object[]{isInNewSubmenu ? 1 : 0, isInJavaIde ? 1 : 0});
    }

    public boolean isDumbAware() {
        return true;
    }

    public static List<Module> doImport(@Nullable Project project2) {
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project2, null);
        if (wizard == null || wizard.getStepCount() > 0 && !wizard.showAndGet()) {
            return Collections.emptyList();
        }
        return ImportModuleAction.createFromWizard(project2, wizard);
    }

    public static List<Module> createFromWizard(@Nullable Project project2, AbstractProjectWizard wizard) {
        Ref result = Ref.create();
        TransactionGuard.getInstance().submitTransactionAndWait(() -> result.set(ImportModuleAction.doCreateFromWizard(project2, wizard)));
        return (List)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Module> doCreateFromWizard(@Nullable Project project2, AbstractProjectWizard wizard) {
        if (project2 == null) {
            Project newProject = NewProjectUtil.createFromWizard(wizard, null);
            return newProject == null ? Collections.emptyList() : Arrays.asList(ModuleManager.getInstance((Project)newProject).getModules());
        }
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        try {
            if (wizard.getStepCount() > 0) {
                Module module2 = new NewModuleAction().createModuleFromWizard(project2, null, wizard);
                List<Module> list = Collections.singletonList(module2);
                return list;
            }
            List list = projectBuilder.commit(project2);
            return list;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project2, @Nullable Component dialogParent) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        descriptor2.setHideIgnored(false);
        descriptor2.setTitle("Select File or Directory to Import");
        List<ProjectImportProvider> providers = ImportModuleAction.getProviders(project2);
        String description = ImportModuleAction.getFileChooserDescription(providers);
        descriptor2.setDescription(description);
        return ImportModuleAction.selectFileAndCreateWizard(project2, dialogParent, descriptor2, providers.toArray(new ProjectImportProvider[0]));
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project2, @Nullable Component dialogParent, @NotNull FileChooserDescriptor descriptor2, ProjectImportProvider[] providers) {
        VirtualFile[] files;
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor2, project2, dialogParent);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(project2, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        if (project2 == null) {
            for (Project p : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectUtil.isSameProject((String)file.getPath(), (Project)p)) continue;
                ProjectUtil.focusProjectWindow((Project)p, (boolean)false);
                return null;
            }
        }
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        return ImportModuleAction.createImportWizard(project2, dialogParent, file, providers);
    }

    private static String getFileChooserDescription(List<ProjectImportProvider> providers) {
        StringBuilder builder = new StringBuilder("<html>Select ");
        boolean first = true;
        if (providers.size() > 0) {
            for (ProjectImportProvider provider2 : providers) {
                String sample = provider2.getFileSample();
                if (sample == null) continue;
                if (!first) {
                    builder.append(", <br>");
                } else {
                    first = false;
                }
                builder.append(sample);
            }
        }
        builder.append(".</html>");
        return builder.toString();
    }

    @NotNull
    public static List<ProjectImportProvider> getProviders(@Nullable Project project2) {
        Object[] providers = (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions();
        return ContainerUtil.filter((Object[])providers, provider2 -> project2 == null ? provider2.canCreateNewProject() : provider2.canImportModule());
    }

    @Nullable
    public static AddModuleWizard createImportWizard(@Nullable Project project2, @Nullable Component dialogParent, @NotNull VirtualFile file, ProjectImportProvider ... providers) {
        List available = ContainerUtil.filter((Object[])providers, provider2 -> provider2.canImport(file, project2));
        if (available.isEmpty()) {
            Messages.showInfoMessage((Project)project2, (String)("Cannot import anything from " + file.getPath()), (String)"Cannot Import");
            return null;
        }
        String path = available.size() == 1 ? ((ProjectImportProvider)available.get(0)).getPathToBeImported(file) : ProjectImportProvider.getDefaultPath(file);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[0]);
        return dialogParent == null ? new AddModuleWizard(project2, path, availableProviders) : new AddModuleWizard(project2, dialogParent, path, availableProviders);
    }
}

