/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NewActionGroup;
import com.intellij.ide.actions.NewProjectOrModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import org.jetbrains.annotations.NotNull;

public class NewProjectAction
extends AnAction
implements DumbAware,
NewProjectOrModuleAction {
    public boolean startInTransaction() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        NewProjectWizard wizard = new NewProjectWizard(null, ModulesProvider.EMPTY_MODULES_PROVIDER, null);
        Project eventProject = NewProjectAction.getEventProject((AnActionEvent)e);
        ApplicationManager.getApplication().invokeLater(() -> NewProjectUtil.createNewProject(eventProject, wizard));
    }

    public void update(@NotNull AnActionEvent e) {
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.CreateNewProject);
        }
        NewProjectAction.updateActionText(this, e);
    }

    @Override
    @NotNull
    public String getActionText(boolean isInNewSubmenu, boolean isInJavaIde) {
        return ProjectBundle.message((String)"new.project.action.text", (Object[])new Object[]{isInNewSubmenu ? 1 : 0, isInJavaIde ? 1 : 0});
    }

    public static <T extends AnAction> void updateActionText(@NotNull T action, @NotNull AnActionEvent e) {
        String actionText;
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            actionText = action.getTemplateText();
        } else {
            boolean inJavaIde = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages().contains(JavaLanguage.INSTANCE);
            boolean fromNewSubMenu = NewProjectAction.isInvokedFromNewSubMenu(action, e);
            actionText = ((NewProjectOrModuleAction)action).getActionText(fromNewSubMenu, inJavaIde);
        }
        e.getPresentation().setText(actionText);
    }

    private static boolean isInvokedFromNewSubMenu(@NotNull AnAction action, @NotNull AnActionEvent e) {
        return NewActionGroup.isActionInNewPopupMenu((AnAction)action) && ("MainMenu".equals(e.getPlace()) || ActionPlaces.isPopupPlace((String)e.getPlace()));
    }
}

