/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WrappingVirtualFile;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureSelectInTarget
implements SelectInTarget,
DumbAware {
    public boolean canSelect(SelectInContext context) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        VirtualFile file = context.getVirtualFile();
        if (file instanceof WrappingVirtualFile) {
            Object o = ((WrappingVirtualFile)file).getWrappedObject(context.getProject());
            return o instanceof Facet;
        }
        return fileIndex.isInContent(file) || fileIndex.isInLibrary(file) || StdFileTypes.IDEA_MODULE.equals(file.getFileType()) && ProjectStructureSelectInTarget.findModuleByModuleFile(context.getProject(), file) != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        Module module2;
        Facet facet;
        Project project2 = context.getProject();
        VirtualFile file = context.getVirtualFile();
        if (file instanceof WrappingVirtualFile) {
            Object o = ((WrappingVirtualFile)file).getWrappedObject(project2);
            facet = o instanceof Facet ? (Facet)o : null;
            module2 = facet == null ? null : facet.getModule();
        } else {
            Module moduleByIml = file.getFileType().equals(StdFileTypes.IDEA_MODULE) ? ProjectStructureSelectInTarget.findModuleByModuleFile(project2, file) : null;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            module2 = moduleByIml != null ? moduleByIml : fileIndex.getModuleForFile(file);
            Facet facet2 = facet = fileIndex.isInSourceContent(file) ? null : ProjectStructureSelectInTarget.findFacet(project2, file);
        }
        if (module2 != null || facet != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (facet != null) {
                    ModulesConfigurator.showFacetSettingsDialog(facet, null);
                } else {
                    ProjectSettingsService.getInstance((Project)project2).openModuleSettings(module2);
                }
            });
            return;
        }
        OrderEntry orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)file, (Project)project2);
        if (orderEntry != null) {
            ApplicationManager.getApplication().invokeLater(() -> ProjectSettingsService.getInstance((Project)project2).openLibraryOrSdkSettings(orderEntry));
        }
    }

    @Nullable
    private static Module findModuleByModuleFile(@NotNull Project project2, @NotNull VirtualFile file) {
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!ModuleUtilCore.isModuleFile((Module)module2, (VirtualFile)file)) continue;
            return module2;
        }
        return null;
    }

    @Nullable
    private static Facet findFacet(@NotNull Project project2, @NotNull VirtualFile file) {
        for (FacetTypeId id : FacetTypeRegistry.getInstance().getFacetTypeIds()) {
            Facet facet;
            if (!ProjectStructureSelectInTarget.hasFacetWithRoots(project2, id) || (facet = FacetFinder.getInstance((Project)project2).findFacet(file, id)) == null) continue;
            return facet;
        }
        return null;
    }

    private static <F extends Facet> boolean hasFacetWithRoots(@NotNull Project project2, @NotNull FacetTypeId<F> id) {
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            Collection facets = FacetManager.getInstance((Module)module2).getFacetsByType(id);
            Iterator iterator2 = facets.iterator();
            if (!iterator2.hasNext()) continue;
            return iterator2.next() instanceof FacetRootsProvider;
        }
        return false;
    }

    public String toString() {
        return IdeBundle.message((String)"select.in.project.settings", (Object[])new Object[0]);
    }

    public float getWeight() {
        return 10.0f;
    }
}

