/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.projectWizard.ModuleNameLocationComponent;
import com.intellij.ide.projectWizard.NewProjectNameLocationSettings;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.projectWizard.EmptyModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsStep
extends ModuleWizardStep
implements SettingsStep {
    private JPanel mySettingsPanel;
    private JPanel myExpertPlaceholder;
    private JPanel myExpertPanel;
    private final HideableDecorator myExpertDecorator;
    private final NamePathComponent myNamePathComponent;
    private final ProjectFormatPanel myFormatPanel;
    private JPanel myPanel;
    private ModuleNameLocationComponent myModuleNameLocationComponent;
    private final WizardContext myWizardContext;
    @Nullable
    private ModuleWizardStep mySettingsStep;

    public ProjectSettingsStep(WizardContext context) {
        this.myWizardContext = context;
        this.$$$setupUI$$$();
        this.myFormatPanel = new ProjectFormatPanel();
        this.myNamePathComponent = NamePathComponent.initNamePathComponent(context);
        this.myNamePathComponent.setShouldBeAbsolute(true);
        JPanel modulePanel = this.getModulePanel();
        if (context.isCreatingNewProject()) {
            this.mySettingsPanel.add((Component)this.myNamePathComponent, "North");
            this.addExpertPanel(modulePanel);
        } else {
            this.mySettingsPanel.add((Component)modulePanel, "North");
        }
        this.myModuleNameLocationComponent.bindModuleSettings(this.myNamePathComponent);
        this.myExpertDecorator = new HideableDecorator(this.myExpertPlaceholder, "Mor&e Settings", false);
        this.myExpertPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)20, (int)5, (int)0));
        this.myExpertDecorator.setContentComponent((JComponent)this.myExpertPanel);
        if (this.myWizardContext.isCreatingNewProject()) {
            this.addProjectFormat(modulePanel);
        }
    }

    private JPanel getModulePanel() {
        return this.myModuleNameLocationComponent.getModulePanel();
    }

    private JTextField getNameComponent() {
        return this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent.getNameComponent() : this.myModuleNameLocationComponent.getModuleNameField();
    }

    private void addProjectFormat(JPanel panel) {
        ProjectSettingsStep.addField("Project \u001bformat:", this.myFormatPanel.getStorageFormatComboBox(), panel);
    }

    public String getHelpId() {
        return this.myWizardContext.isCreatingNewProject() ? "New_Project_Main_Settings" : "Add_Module_Main_Settings";
    }

    private void setupPanels() {
        ModuleBuilder moduleBuilder = (ModuleBuilder)this.myWizardContext.getProjectBuilder();
        ProjectSettingsStep.restorePanel(this.myNamePathComponent, 4);
        ProjectSettingsStep.restorePanel(this.getModulePanel(), this.myWizardContext.isCreatingNewProject() ? 8 : 6);
        ProjectSettingsStep.restorePanel(this.myExpertPanel, this.myWizardContext.isCreatingNewProject() ? 1 : 0);
        this.mySettingsStep = moduleBuilder == null ? null : moduleBuilder.modifySettingsStep((SettingsStep)this);
        this.myExpertPlaceholder.setVisible(!(moduleBuilder instanceof TemplateModuleBuilder) && this.myExpertPanel.getComponentCount() > 0);
        for (int i = 0; i < 6; ++i) {
            this.getModulePanel().getComponent(i).setVisible(!(moduleBuilder instanceof EmptyModuleBuilder));
        }
        this.mySettingsPanel.revalidate();
        this.mySettingsPanel.repaint();
    }

    private static void restorePanel(JPanel component, int i) {
        while (component.getComponentCount() > i) {
            component.remove(component.getComponentCount() - 1);
        }
    }

    public void updateStep() {
        this.myExpertDecorator.setOn(SelectTemplateSettings.getInstance().EXPERT_MODE);
        this.setupPanels();
    }

    public void onStepLeaving() {
        SelectTemplateSettings settings = SelectTemplateSettings.getInstance();
        settings.EXPERT_MODE = this.myExpertDecorator.isExpanded();
    }

    public boolean validate() throws ConfigurationException {
        if (this.myWizardContext.isCreatingNewProject() && !this.myNamePathComponent.validateNameAndPath(this.myWizardContext, this.myFormatPanel.isDefault())) {
            return false;
        }
        if (!this.myModuleNameLocationComponent.validate()) {
            return false;
        }
        if (this.mySettingsStep != null) {
            return this.mySettingsStep.validate();
        }
        return true;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getNameComponent();
    }

    public void updateDataModel() {
        this.myWizardContext.setProjectName(this.myNamePathComponent.getNameValue());
        this.myWizardContext.setProjectFileDirectory(this.myNamePathComponent.getPath());
        this.myFormatPanel.updateData(this.myWizardContext);
        this.myModuleNameLocationComponent.updateDataModel();
        ProjectBuilder moduleBuilder = this.myWizardContext.getProjectBuilder();
        if (moduleBuilder instanceof TemplateModuleBuilder) {
            this.myWizardContext.setProjectStorageFormat(StorageScheme.DIRECTORY_BASED);
        }
        if (this.mySettingsStep != null) {
            this.mySettingsStep.updateDataModel();
        }
    }

    public String getName() {
        return "Project Settings";
    }

    public WizardContext getContext() {
        return this.myWizardContext;
    }

    public void addSettingsField(@NotNull String label, @NotNull JComponent field) {
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent : this.getModulePanel();
        ProjectSettingsStep.addField(label, field, panel);
    }

    static void addField(String label, JComponent field, JPanel panel) {
        JBLabel jLabel = new JBLabel(label);
        jLabel.setLabelFor(field);
        jLabel.setVerticalAlignment(1);
        panel.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 3, (Insets)JBUI.insets((int)5, (int)0, (int)5, (int)0), 4, 0));
        panel.add((Component)field, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insetsBottom((int)5), 0, 0));
    }

    public void addSettingsComponent(@NotNull JComponent component) {
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent : this.getModulePanel();
        panel.add((Component)component, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public void addExpertPanel(@NotNull JComponent panel) {
        this.myExpertPanel.add((Component)panel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public void addExpertField(@NotNull String label, @NotNull JComponent field) {
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.getModulePanel() : this.myExpertPanel;
        ProjectSettingsStep.addField(label, field, panel);
    }

    @NotNull
    public JTextField getModuleNameField() {
        return this.getNameComponent();
    }

    @Nullable
    public ModuleNameLocationSettings getModuleNameLocationSettings() {
        return this.myWizardContext.isCreatingNewProject() ? new NewProjectNameLocationSettings(this.myNamePathComponent, this.myModuleNameLocationComponent) : this.myModuleNameLocationComponent;
    }

    @Nullable
    public ModuleWizardStep getSettingsStep() {
        return this.mySettingsStep;
    }

    public Icon getIcon() {
        return null;
    }

    private void createUIComponents() {
        this.myModuleNameLocationComponent = new ModuleNameLocationComponent(this.myWizardContext);
    }

    public void setModuleName(String moduleName) {
        this.myModuleNameLocationComponent.setModuleName(moduleName);
    }

    public void bindModuleSettings() {
        this.myModuleNameLocationComponent.bindModuleSettings(this.myNamePathComponent);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExpertPlaceholder = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExpertPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel2, "Center");
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ModuleNameLocationComponent moduleNameLocationComponent = this.myModuleNameLocationComponent;
        JComponent jComponent = moduleNameLocationComponent.$$$getRootComponent$$$();
        jPanel5.add((Component)jComponent, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

