/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class CustomLibraryDescriptionBase
extends CustomLibraryDescription {
    private final String myDefaultLibraryName;

    protected CustomLibraryDescriptionBase(@NotNull String defaultLibraryName) {
        this.myDefaultLibraryName = defaultLibraryName;
    }

    @Override
    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, VirtualFile contextDirectory) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, false, true, false, false, true);
        descriptor2.setTitle(IdeBundle.message((String)"new.library.file.chooser.title", (Object[])new Object[0]));
        descriptor2.setDescription(IdeBundle.message((String)"new.library.file.chooser.description", (Object[])new Object[0]));
        final VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Component)parentComponent, null, (VirtualFile)contextDirectory);
        if (files.length == 0) {
            return null;
        }
        return new NewLibraryConfiguration(this.myDefaultLibraryName, this.getDownloadableLibraryType(), new LibraryVersionProperties()){

            public void addRoots(@NotNull LibraryEditor editor) {
                for (VirtualFile file : files) {
                    editor.addRoot(file, OrderRootType.CLASSES);
                }
            }
        };
    }
}

