/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.framework.library.FrameworkSupportWithLibrary;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.ide.util.frameworkSupport.OldCustomLibraryDescription;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.EmptyIcon;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OldFrameworkSupportProviderWrapper
extends FrameworkSupportInModuleProvider {
    private final FrameworkSupportProvider myProvider;
    private final FrameworkSupportProviderBasedType myType;

    public OldFrameworkSupportProviderWrapper(FrameworkSupportProvider provider2) {
        this.myProvider = provider2;
        this.myType = new FrameworkSupportProviderBasedType(this.myProvider, this);
    }

    public FrameworkSupportProvider getProvider() {
        return this.myProvider;
    }

    @Override
    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        return this.myType;
    }

    @Override
    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        FrameworkSupportConfigurable configurable = this.myProvider.createConfigurable(model);
        return new FrameworkSupportConfigurableWrapper(configurable);
    }

    @Override
    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        return this.myProvider.isEnabledForModuleType(moduleType);
    }

    @Override
    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        return this.myProvider.isEnabledForModuleBuilder(builder);
    }

    @Override
    public boolean isSupportAlreadyAdded(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        return this.myProvider.isSupportAlreadyAdded(module2, facetsProvider);
    }

    @Override
    public FrameworkRole[] getRoles() {
        return this.myProvider.getRoles();
    }

    public static class FrameworkSupportConfigurableWrapper
    extends FrameworkSupportInModuleConfigurable {
        private final FrameworkSupportConfigurable myConfigurable;
        private final FrameworkLibraryVersionFilter myVersionFilter;

        public FrameworkSupportConfigurableWrapper(FrameworkSupportConfigurable configurable) {
            Disposer.register((Disposable)this, (Disposable)configurable);
            this.myConfigurable = configurable;
            this.myVersionFilter = this.getVersionFilter(configurable);
        }

        private FrameworkLibraryVersionFilter getVersionFilter(FrameworkSupportConfigurable configurable) {
            FrameworkLibraryVersionFilter filter;
            if (configurable instanceof FrameworkSupportWithLibrary && (filter = configurable.getVersionFilter()) != null) {
                return filter;
            }
            return new FrameworkLibraryVersionFilter(){

                public boolean isAccepted(@NotNull FrameworkLibraryVersion version) {
                    FrameworkVersion selectedVersion = myConfigurable.getSelectedVersion();
                    return selectedVersion == null || version.getVersionString().equals(selectedVersion.getVersionName());
                }
            };
        }

        public FrameworkSupportConfigurable getConfigurable() {
            return this.myConfigurable;
        }

        @Override
        public void onFrameworkSelectionChanged(boolean selected) {
            this.myConfigurable.onFrameworkSelectionChanged(selected);
        }

        @Override
        public boolean isVisible() {
            return this.myConfigurable.isVisible();
        }

        @Override
        public JComponent createComponent() {
            return this.myConfigurable.getComponent();
        }

        @Override
        public boolean isOnlyLibraryAdded() {
            return this.myConfigurable instanceof FrameworkSupportWithLibrary && ((FrameworkSupportWithLibrary)this.myConfigurable).isLibraryOnly();
        }

        @Override
        public CustomLibraryDescription createLibraryDescription() {
            if (this.myConfigurable instanceof FrameworkSupportWithLibrary) {
                return ((FrameworkSupportWithLibrary)this.myConfigurable).createLibraryDescription();
            }
            List versions = this.myConfigurable.getVersions();
            if (versions.isEmpty()) {
                return null;
            }
            return OldCustomLibraryDescription.createByVersions(versions);
        }

        @Override
        @NotNull
        public FrameworkLibraryVersionFilter getLibraryVersionFilter() {
            return this.myVersionFilter;
        }

        @Override
        public void addSupport(@NotNull Module module2, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider2) {
            this.myConfigurable.addSupport(module2, rootModel, null);
        }
    }

    public static class FrameworkSupportProviderBasedType
    extends FrameworkTypeEx {
        private final FrameworkSupportProvider myOldProvider;
        private final OldFrameworkSupportProviderWrapper myNewProvider;

        private FrameworkSupportProviderBasedType(FrameworkSupportProvider oldProvider, OldFrameworkSupportProviderWrapper newProvider) {
            super(oldProvider.getId());
            this.myOldProvider = oldProvider;
            this.myNewProvider = newProvider;
        }

        @Override
        @NotNull
        public FrameworkSupportInModuleProvider createProvider() {
            return this.myNewProvider;
        }

        @NotNull
        public String getPresentableName() {
            return GuiUtils.getTextWithoutMnemonicEscaping((String)this.myOldProvider.getTitle());
        }

        @Override
        public String getUnderlyingFrameworkTypeId() {
            return this.myOldProvider.getUnderlyingFrameworkId();
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myOldProvider.getIcon();
            return icon != null ? icon : EmptyIcon.ICON_16;
        }

        public FrameworkSupportProvider getProvider() {
            return this.myOldProvider;
        }
    }
}

