/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepSequence {
    private final List<ModuleWizardStep> myCommonSteps;
    private final List<Pair<ModuleWizardStep, Set<String>>> myCommonFinishingSteps = new ArrayList<Pair<ModuleWizardStep, Set<String>>>();
    private final MultiMap<String, ModuleWizardStep> mySpecificSteps = new MultiMap();
    private final MultiMap<String, ModuleWizardStep> mySpecificFinishingSteps = new MultiMap();
    @NonNls
    private final List<String> myTypes = new ArrayList<String>();
    private List<ModuleWizardStep> mySelectedSteps;

    public StepSequence(ModuleWizardStep ... commonSteps) {
        this.myCommonSteps = new SmartList((Object[])commonSteps);
    }

    public void addCommonStep(@NotNull ModuleWizardStep step) {
        this.myCommonSteps.add(step);
    }

    public void addCommonFinishingStep(@NotNull ModuleWizardStep step, @Nullable Set<String> suitableTypes) {
        this.myCommonFinishingSteps.add((Pair<ModuleWizardStep, Set<String>>)Pair.create((Object)step, suitableTypes));
    }

    public void addStepsForBuilder(@NotNull AbstractModuleBuilder builder, @NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        String id = builder.getBuilderId();
        if (!this.mySpecificSteps.containsKey((Object)id)) {
            this.mySpecificSteps.put((Object)id, Arrays.asList(builder.createWizardSteps(wizardContext, modulesProvider)));
        }
        if (!this.mySpecificFinishingSteps.containsKey((Object)id)) {
            this.mySpecificFinishingSteps.put((Object)id, Arrays.asList(builder.createFinishingSteps(wizardContext, modulesProvider)));
        }
    }

    public void addSpecificStep(String type, ModuleWizardStep step) {
        this.mySpecificSteps.putValue((Object)type, (Object)step);
    }

    public List<ModuleWizardStep> getSelectedSteps() {
        if (this.mySelectedSteps == null) {
            Collection steps;
            this.mySelectedSteps = new ArrayList<ModuleWizardStep>();
            this.mySelectedSteps.addAll(this.myCommonSteps);
            for (String string : this.myTypes) {
                steps = this.mySpecificSteps.get((Object)string);
                this.mySelectedSteps.addAll(steps);
            }
            for (Pair pair2 : this.myCommonFinishingSteps) {
                Set types = (Set)pair2.getSecond();
                if (types != null && !ContainerUtil.intersects(this.myTypes, (Collection)types)) continue;
                this.mySelectedSteps.add((ModuleWizardStep)pair2.getFirst());
            }
            for (String string : this.myTypes) {
                steps = this.mySpecificFinishingSteps.get((Object)string);
                this.mySelectedSteps.addAll(steps);
            }
            ContainerUtil.removeDuplicates(this.mySelectedSteps);
        }
        return this.mySelectedSteps;
    }

    @Nullable
    public ModuleWizardStep getNextStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i = steps.indexOf(step);
        return i < steps.size() - 1 ? steps.get(i + 1) : null;
    }

    @Nullable
    public ModuleWizardStep getPreviousStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i = steps.indexOf(step);
        return i > 0 ? steps.get(i - 1) : null;
    }

    public void setTypes(Collection<String> types) {
        this.myTypes.clear();
        this.myTypes.addAll(types);
        this.mySelectedSteps = null;
    }

    public void setType(@Nullable @NonNls String type) {
        this.setTypes(Collections.singletonList(type == null ? ModuleType.EMPTY.getId() : type));
    }

    public String getSelectedType() {
        return (String)ContainerUtil.getFirstItem(this.myTypes);
    }

    public List<ModuleWizardStep> getAllSteps() {
        ArrayList<ModuleWizardStep> result = new ArrayList<ModuleWizardStep>();
        result.addAll(this.myCommonSteps);
        result.addAll(this.mySpecificSteps.values());
        for (Pair<ModuleWizardStep, Set<String>> pair2 : this.myCommonFinishingSteps) {
            result.add((ModuleWizardStep)pair2.getFirst());
        }
        result.addAll(this.mySpecificFinishingSteps.values());
        ContainerUtil.removeDuplicates(result);
        return result;
    }
}

