/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.impl;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.addSupport.FrameworkVersionListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNodeBase;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportOptionsComponent;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportModelBase
extends UserDataHolderBase
implements FrameworkSupportModel {
    private final Project myProject;
    private final ModuleBuilder myModuleBuilder;
    private final LibrariesContainer myLibrariesContainer;
    private final EventDispatcher<FrameworkSupportModelListener> myDispatcher = EventDispatcher.create(FrameworkSupportModelListener.class);
    private final EventDispatcher<FrameworkVersionListener> myVersionEventDispatcher = EventDispatcher.create(FrameworkVersionListener.class);
    private final Map<String, FrameworkSupportNode> mySettingsMap = new HashMap<String, FrameworkSupportNode>();
    private final Map<String, FrameworkSupportOptionsComponent> myOptionsComponentsMap = new HashMap<String, FrameworkSupportOptionsComponent>();
    private final Map<String, FrameworkVersion> mySelectedVersions = new HashMap<String, FrameworkVersion>();
    private final Map<String, String> myFrameworkVersions = new HashMap<String, String>();
    private FrameworkLibraryProvider myLibraryProvider;

    public FrameworkSupportModelBase(@Nullable Project project2, @Nullable ModuleBuilder builder, @NotNull LibrariesContainer librariesContainer) {
        this.myProject = project2;
        this.myModuleBuilder = builder;
        this.myLibrariesContainer = librariesContainer;
    }

    @NotNull
    public abstract String getBaseDirectoryForLibrariesPath();

    public void registerComponent(@NotNull FrameworkSupportInModuleProvider provider2, @NotNull FrameworkSupportNode node) {
        this.mySettingsMap.put(provider2.getFrameworkType().getId(), node);
    }

    public void registerOptionsComponent(FrameworkSupportInModuleProvider provider2, FrameworkSupportOptionsComponent component) {
        this.myOptionsComponentsMap.put(provider2.getFrameworkType().getId(), component);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ModuleBuilder getModuleBuilder() {
        return this.myModuleBuilder;
    }

    public boolean isFrameworkSelected(@NotNull @NonNls String providerId) {
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        return node != null && node.isChecked();
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener listener, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void addFrameworkVersionListener(@NotNull FrameworkVersionListener listener, @NotNull Disposable parentDisposable) {
        this.myVersionEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void removeFrameworkListener(@NotNull FrameworkSupportModelListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void setFrameworkComponentEnabled(@NotNull @NonNls String providerId, boolean enable) {
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        if (node != null && enable != node.isChecked()) {
            node.setChecked(enable);
            node.getConfigurable();
            if (this.myFrameworkVersions.get(providerId) == null) {
                for (FrameworkVersion version : ((FrameworkSupportInModuleProvider)node.getUserObject()).getFrameworkType().getVersions()) {
                    if (!version.getAvailabilityCondition().isAvailableFor((FrameworkSupportModel)this)) continue;
                    this.setSelectedVersion(providerId, version);
                }
            }
        }
    }

    public void updateFrameworkLibraryComponent(@NotNull String providerId) {
        FrameworkSupportOptionsComponent component = this.myOptionsComponentsMap.get(providerId);
        if (component != null) {
            component.updateLibrariesPanel();
        }
    }

    public FrameworkSupportConfigurable getFrameworkConfigurable(@NotNull @NonNls String providerId) {
        FrameworkSupportConfigurable configurable = this.findFrameworkConfigurable(providerId);
        if (configurable == null) {
            throw new IllegalArgumentException("provider '" + providerId + "' not found");
        }
        return configurable;
    }

    @Nullable
    public FrameworkSupportConfigurable findFrameworkConfigurable(@NotNull @NonNls String providerId) {
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        if (node == null) {
            return null;
        }
        return ((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)node.getConfigurable()).getConfigurable();
    }

    public void setSelectedVersion(@NotNull String frameworkOrGroupId, @NotNull FrameworkVersion version) {
        FrameworkVersion oldVersion = this.mySelectedVersions.put(frameworkOrGroupId, version);
        if (!Comparing.equal((Object)oldVersion, (Object)version)) {
            for (Map.Entry<String, FrameworkSupportNode> entry : this.mySettingsMap.entrySet()) {
                FrameworkSupportOptionsComponent component;
                if (!FrameworkSupportModelBase.hasParentWithId(entry.getValue(), frameworkOrGroupId)) continue;
                if (!entry.getValue().getId().equals(frameworkOrGroupId) && (component = this.myOptionsComponentsMap.get(entry.getKey())) != null) {
                    component.updateVersionsComponent();
                }
                this.updateFrameworkLibraryComponent(entry.getKey());
            }
        }
        ((FrameworkVersionListener)this.myVersionEventDispatcher.getMulticaster()).versionChanged(version);
    }

    private static boolean hasParentWithId(FrameworkSupportNode node, @NotNull String frameworkOrGroupId) {
        for (FrameworkSupportNodeBase current = node; current != null; current = current.getParentNode()) {
            if (!current.getId().equals(frameworkOrGroupId)) continue;
            return true;
        }
        return false;
    }

    public FrameworkLibraryProvider getLibraryProvider() {
        return this.myLibraryProvider;
    }

    public void setLibraryProvider(@Nullable FrameworkLibraryProvider libraryProvider) {
        this.myLibraryProvider = libraryProvider;
        for (FrameworkSupportOptionsComponent optionsComponent : this.myOptionsComponentsMap.values()) {
            optionsComponent.updateLibrariesPanel();
        }
    }

    @Nullable
    public <V extends FrameworkVersion> V getSelectedVersion(@NotNull String frameworkOrGroupId) {
        return (V)this.mySelectedVersions.get(frameworkOrGroupId);
    }

    public void onFrameworkSelectionChanged(FrameworkSupportNode node) {
        FrameworkSupportInModuleProvider provider2 = (FrameworkSupportInModuleProvider)node.getUserObject();
        boolean checked = node.isChecked();
        if (provider2 instanceof OldFrameworkSupportProviderWrapper) {
            FrameworkSupportProvider oldProvider = ((OldFrameworkSupportProviderWrapper)provider2).getProvider();
            this.selectFramework(oldProvider, checked);
        }
        for (FrameworkSupportInModuleProvider.FrameworkDependency dependency : provider2.getDependenciesFrameworkIds()) {
            if (dependency.isOptional()) continue;
            String id = dependency.getFrameworkId();
            this.setFrameworkComponentEnabled(id, true);
        }
    }

    public void selectFramework(FrameworkSupportProvider provider2, boolean checked) {
        FrameworkSupportModelListener multicaster = (FrameworkSupportModelListener)this.myDispatcher.getMulticaster();
        if (checked) {
            multicaster.frameworkSelected(provider2);
        } else {
            multicaster.frameworkUnselected(provider2);
        }
    }

    public void fireWizardStepUpdated() {
        ((FrameworkSupportModelListener)this.myDispatcher.getMulticaster()).wizardStepUpdated();
    }

    @NotNull
    public LibrariesContainer getLibrariesContainer() {
        return this.myLibrariesContainer;
    }

    public void setSelectedLibraryVersion(String id, String version) {
        this.myFrameworkVersions.put(id, version);
        ((FrameworkVersionListener)this.myVersionEventDispatcher.getMulticaster()).versionChanged((FrameworkVersion)this.getSelectedVersion(id));
    }

    public String getFrameworkVersion(String id) {
        FrameworkVersion version = this.mySelectedVersions.get(id);
        return version == null ? this.myFrameworkVersions.get(id) : version.getVersionNumber();
    }
}

