/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkSettingsStep
extends ModuleWizardStep {
    protected final JdkComboBox myJdkComboBox;
    protected final WizardContext myWizardContext;
    protected final ProjectSdksModel myModel;
    private final ModuleBuilder myModuleBuilder;
    private final JPanel myJdkPanel;

    public SdkSettingsStep(SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<? super SdkTypeId> sdkTypeIdFilter) {
        this(settingsStep, moduleBuilder, sdkTypeIdFilter, null);
    }

    public SdkSettingsStep(SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<? super SdkTypeId> sdkTypeIdFilter, @Nullable Condition<? super Sdk> sdkFilter) {
        this(settingsStep.getContext(), moduleBuilder, sdkTypeIdFilter, sdkFilter);
        if (!this.isEmpty()) {
            settingsStep.addSettingsField(this.getSdkFieldLabel(settingsStep.getContext().getProject()), (JComponent)this.myJdkPanel);
        }
    }

    public SdkSettingsStep(WizardContext context, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<? super SdkTypeId> sdkTypeIdFilter, @Nullable Condition<? super Sdk> sdkFilter) {
        SdkType type;
        this.myModuleBuilder = moduleBuilder;
        this.myWizardContext = context;
        this.myModel = new ProjectSdksModel();
        Project project2 = this.myWizardContext.getProject();
        this.myModel.reset(project2);
        if (sdkFilter == null) {
            sdkFilter = JdkComboBox.getSdkFilter(sdkTypeIdFilter);
        }
        this.myJdkComboBox = new JdkComboBox(this.myModel, sdkTypeIdFilter, sdkFilter, sdkTypeIdFilter, true);
        this.myJdkPanel = new JPanel(new GridBagLayout());
        final PropertiesComponent component = project2 == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project2);
        ModuleType moduleType = moduleBuilder.getModuleType();
        final String selectedJdkProperty = "jdk.selected." + (moduleType == null ? "" : moduleType.getId());
        this.myJdkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk jdk = SdkSettingsStep.this.myJdkComboBox.getSelectedJdk();
                if (jdk != null) {
                    component.setValue(selectedJdkProperty, jdk.getName());
                }
                SdkSettingsStep.this.onSdkSelected(jdk);
            }
        });
        Sdk sdk = this.getPreselectedSdk(project2, component.getValue(selectedJdkProperty), sdkTypeIdFilter);
        this.myJdkComboBox.setSelectedJdk(sdk);
        JButton button = new JButton("Ne\u001bw...");
        this.myJdkComboBox.setSetupButton(button, project2, this.myModel, project2 == null ? new JdkComboBox.NoneJdkComboBoxItem() : new JdkComboBox.ProjectJdkComboBoxItem(), null, false);
        this.myJdkPanel.add((Component)((Object)this.myJdkComboBox), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myJdkPanel.add((Component)this.myJdkComboBox.getSetUpButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)4), 0, 0));
        if (this.myJdkComboBox.getItemCount() == 0 && (type = (SdkType)ContainerUtil.find((Object[])SdkType.getAllTypes(), sdkTypeIdFilter)) != null && type.getDownloadSdkUrl() != null) {
            HyperlinkLabel label = new HyperlinkLabel("Download " + type.getPresentableName());
            label.setHyperlinkTarget(type.getDownloadSdkUrl());
            this.myJdkPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        }
    }

    private Sdk getPreselectedSdk(Project project2, String lastUsedSdk, Condition<? super SdkTypeId> sdkFilter) {
        Sdk sdk;
        if (project2 != null && (sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk()) != null && this.myModuleBuilder.isSuitableSdkType(sdk.getSdkType())) {
            this.myJdkComboBox.insertItemAt(new JdkComboBox.ProjectJdkComboBoxItem(), 0);
            return null;
        }
        if (lastUsedSdk != null && (sdk = ProjectJdkTable.getInstance().findJdk(lastUsedSdk)) != null && this.myModuleBuilder.isSuitableSdkType(sdk.getSdkType())) {
            return sdk;
        }
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        Sdk selected = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        if (selected != null && sdkFilter.value((Object)selected.getSdkType())) {
            return selected;
        }
        return this.myJdkComboBox.getSelectedJdk();
    }

    protected void onSdkSelected(Sdk sdk) {
    }

    public boolean isEmpty() {
        return this.myJdkPanel.getComponentCount() == 0;
    }

    @NotNull
    protected String getSdkFieldLabel(@Nullable Project project2) {
        return (project2 == null ? "Project" : "Module") + " \u001bSDK:";
    }

    public JComponent getComponent() {
        return this.myJdkPanel;
    }

    public void updateDataModel() {
        Project project2 = this.myWizardContext.getProject();
        Sdk jdk = this.myJdkComboBox.getSelectedJdk();
        if (project2 == null) {
            this.myWizardContext.setProjectJdk(jdk);
        } else {
            this.myModuleBuilder.setModuleJdk(jdk);
        }
    }

    public boolean validate() throws ConfigurationException {
        block4: {
            JdkComboBox.JdkComboBoxItem item = this.myJdkComboBox.getSelectedItem();
            if (this.myJdkComboBox.getSelectedJdk() == null && !(item instanceof JdkComboBox.ProjectJdkComboBoxItem) && !(item instanceof JdkComboBox.SuggestedJdkItem) && Messages.showDialog((String)this.getNoSdkMessage(), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            try {
                if (item instanceof JdkComboBox.SuggestedJdkItem) {
                    SdkType type = ((JdkComboBox.SuggestedJdkItem)item).getSdkType();
                    String path = ((JdkComboBox.SuggestedJdkItem)item).getPath();
                    this.myModel.addSdk(type, path, sdk -> {
                        this.myJdkComboBox.reloadModel(new JdkComboBox.ActualJdkComboBoxItem((Sdk)sdk), this.myWizardContext.getProject());
                        this.myJdkComboBox.setSelectedJdk((Sdk)sdk);
                    });
                }
                this.myModel.apply(null, true);
            }
            catch (ConfigurationException e) {
                if (Messages.showDialog((String)(e.getMessage() + "\n\nDo you want to proceed?"), (String)e.getTitle(), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) == 0) break block4;
                return false;
            }
        }
        return true;
    }

    protected String getNoSdkMessage() {
        return IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]);
    }
}

