/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleSourceRoot
extends DetectedSourceRoot {
    private final List<String> myLanguages;
    private final boolean myWithModuleInfoFile;

    public JavaModuleSourceRoot(File directory, @Nullable String packagePrefix, @NotNull String language) {
        super(directory, packagePrefix);
        this.myLanguages = new ArrayList<String>();
        this.myLanguages.add(language);
        this.myWithModuleInfoFile = false;
    }

    public JavaModuleSourceRoot(File directory, @NotNull String language, boolean withModuleInfoFile) {
        super(directory, "");
        this.myLanguages = new ArrayList<String>();
        this.myLanguages.add(language);
        this.myWithModuleInfoFile = withModuleInfoFile;
    }

    private JavaModuleSourceRoot(File directory, String packagePrefix, List<String> languages) {
        super(directory, packagePrefix);
        this.myLanguages = languages;
        this.myWithModuleInfoFile = false;
    }

    @Override
    @NotNull
    public String getRootTypeName() {
        return StringUtil.join(this.myLanguages, (String)", ");
    }

    @Override
    public DetectedProjectRoot combineWith(@NotNull DetectedProjectRoot root) {
        if (root instanceof JavaModuleSourceRoot) {
            return this.combineWith((JavaModuleSourceRoot)root);
        }
        return null;
    }

    @NotNull
    public JavaModuleSourceRoot combineWith(@NotNull JavaModuleSourceRoot root) {
        ArrayList<String> union = new ArrayList<String>(this.myLanguages.size() + root.myLanguages.size());
        union.addAll(this.myLanguages);
        union.addAll(root.myLanguages);
        ContainerUtil.removeDuplicates(union);
        return new JavaModuleSourceRoot(this.getDirectory(), this.getPackagePrefix(), union);
    }

    public boolean isWithModuleInfoFile() {
        return this.myWithModuleInfoFile;
    }
}

