/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.impl;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.ide.util.importProject.JavaModuleInsight;
import com.intellij.ide.util.importProject.LibrariesDetectionStep;
import com.intellij.ide.util.importProject.ModulesDetectionStep;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectJdkStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetector;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JavaProjectStructureDetector
extends JavaSourceRootDetector {
    @Override
    @NotNull
    protected String getLanguageName() {
        return "Java";
    }

    @Override
    @NotNull
    protected String getFileExtension() {
        return "java";
    }

    @Override
    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        ArrayList<ModuleWizardStep> steps = new ArrayList<ModuleWizardStep>();
        JavaModuleInsight moduleInsight = new JavaModuleInsight((ProgressIndicator)new DelegatingProgressIndicator(), builder.getExistingModuleNames(), builder.getExistingProjectLibraryNames());
        steps.add(new LibrariesDetectionStep(builder, projectDescriptor, moduleInsight, stepIcon, "reference.dialogs.new.project.fromCode.page1"));
        steps.add(new ModulesDetectionStep(this, builder, projectDescriptor, moduleInsight, stepIcon, "reference.dialogs.new.project.fromCode.page2"));
        if (builder.getContext().isCreatingNewProject()) {
            ModuleWizardStep jdkStep = ProjectWizardStepFactory.getInstance().createProjectJdkStep(builder.getContext());
            steps.add(jdkStep);
            if (jdkStep instanceof ProjectJdkStep) {
                ((ProjectJdkStep)jdkStep).setProjectDescriptor(projectDescriptor);
            }
        }
        return steps;
    }

    @Override
    @NotNull
    protected NullableFunction<CharSequence, String> getPackageNameFetcher() {
        return charSequence -> JavaSourceRootDetectionUtil.getPackageName(charSequence);
    }
}

